# 项目管理模块

## 查看指定代码库的指定分析项目列表

```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| scm_url_or_name | str | 代码库地址或者名称，支持模糊匹配 |
| scm_url | str | 代码库仓库匹配|
| scope | str | 过滤范围（my/subscribed/related_me），my表示我创建的，subscribed表示我关注的，related_me表示我有权限的 |

#### 返回结果
```JSON
{
    "count": 1,
    "next": null,
    "previous": null,
    "results": [
        {
            "id": 1,
            "name": "test_repo.git",
            "scm_url": "http://git.com/xxx/test_repo",
            "scm_type": "git",
            "branch_count": 1,
            "scheme_count": 1,
            "job_count": 1,
            "created_time": "2021-03-15 02:26:31.423674+00:00",
            "recent_active": {
                "id": 1,
                "branch_name": "master",
                "active_time": "2021-03-15T03:14:56.760427Z",
                "total_line_num": null,
                "code_line_num": null
            },
            "created_from": "codedog_web",
            "creator": {
                "username": "username",
                "nickname": "nickname",
                "status": 1,
                "avatar": null,
                "org": 1
            },
            "symbol": null
        }
    ]
}
```

## 查看指定代码库详情

```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/
```

#### 返回结果
```JSON
{
    "data":{
        "id": 1,
        "name": "test_repo.git",
        "scm_url": "http://git.com/xxx/test_repo",
        "scm_type": "git",
        "branch_count": 1,
        "scheme_count": 1,
        "job_count": 1,
        "created_time": "2021-03-15 02:26:31.423674+00:00",
        "recent_active": {
            "id": 1,
            "branch_name": "master",
            "active_time": "2021-03-15T03:14:56.760427Z",
            "total_line_num": null,
            "code_line_num": null
        },
        "created_from": "codedog_web",
        "creator": {
            "username": "username",
            "nickname": "nickname",
            "status": 1,
            "avatar": null,
            "org": 1
        },
        "symbol": null
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```


## 查看指定代码库的不同分支的列表接口

```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/branches/
```

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "branch": "master",
                "schemes": [
                    {
                        "project_id": 1,
                        "scan_scheme_id": 1,
                        "scan_scheme_name": "默认"
                    }
                ]
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定代码库的分析项目列表

```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| branch | str | 分支名称 |
| scan_scheme | int | 扫描方案名称 |
| scan_scheme__status | int | 扫描方案状态，1为活跃，2为废弃 |
| branch_or_scheme | str | 分支名称/扫描方案名称 |
| status | int | 项目状态筛选，1表示活跃，2表示失活，3表示关闭 |

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "creator": {
                    "username": "username",
                    "nickname": "nickname",
                    "status": 1,
                    "avatar": null,
                    "org": 1
                },
                "created_time": "2021-01-28 02:27:26.256015+00:00",
                "modifier": null,
                "modified_time": "2021-01-28 02:27:26.256284+00:00",
                "deleter": null,
                "deleted_time": null,
                "scan_scheme": {
                    "id": 1,
                    "creator": {
                        "username": "username",
                        "nickname": "nickname",
                        "status": 1,
                        "avatar": null,
                        "org": 1
                    },
                    "created_time": "2021-01-28 02:27:26.209661+00:00",
                    "modifier": null,
                    "modified_time": "2021-01-28 02:27:26.255023+00:00",
                    "deleter": null,
                    "deleted_time": null,
                    "languages": [
                        "python"
                    ],
                    "tag": "TCA_Linux",
                    "refer_scheme_info": null,
                    "name": "默认",
                    "description": null,
                    "default_flag": true,
                    "created_from": "web",
                    "job_runtime_limit": 600,
                    "ignore_merged_issue": false,
                    "ignore_branch_issue": null,
                    "ignore_submodule_clone": false,
                    "ignore_submodule_issue": true,
                    "issue_global_ignore": false,
                    "daily_save": false,
                    "lfs_flag": null,
                    "webhook_flag": false,
                    "issue_revision_merge_flag": false,
                    "status": 1,
                    "scheme_key": null,
                    "repo": 1
                },
                "branch": "master",
                "status": 1,
                "created_from": "codedog_web",
                "repo": 1
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 创建指定代码库的指定分析项目

```
POST /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/projects/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| scan_scheme_id | int | 当前代码库的扫描方案编号 |
| global_scheme_id | int | 扫描方案模板编号 |
| custom_scheme_name | str | 自定义方案名称 |
| branch | str | 分支 |
| created_from | str | 创建渠道，用于区分不同运行场景 |

#### 返回结果
```JSON
{
    "data": {
        "id":1,
        "creator": {
            "username": "username",
            "nickname": "nickname",
            "status": 1,
            "avatar": null,
            "org": 1
        },
        "created_time": "2021-01-28 02:27:26.256015+00:00",
        "modifier": null,
        "modified_time": "2021-01-28 02:27:26.256284+00:00",
        "deleter": null,
        "deleted_time": null,
        "repo": {
            "id": 1,
            "name": "test_demo.git",
            "scm_url": "http://github.com/xxxx/test_demo.git",
            "scm_type": "git",
            "scm_auth": {
                "id": 1,
                "scm_account": null,
                "scm_oauth": null,
                "scm_ssh": {
                    "id": 1,
                    "name": "1",
                    "scm_platform": 1,
                    "scm_platform_desc": null,
                    "user": {
                        "username": "username",
                        "nickname": "nickname",
                        "status": 1,
                        "avatar": null,
                        "org": 1
                    }
                },
                "auth_type": "ssh_token",
                "created_time": "2021-01-28T10:26:31.453389+08:00",
                "modified_time": "2021-01-28T10:26:31.453417+08:00"
            },
            "symbol": null
        },
        "scan_scheme": {
            "id": 1,
            "creator": {
                "username": "username",
                "nickname": "nickname",
                "status": 1,
                "avatar": null,
                "org": 1
            },
            "created_time": "2021-01-28 02:27:26.209661+00:00",
            "modifier": null,
            "modified_time": "2021-01-28 02:27:26.255023+00:00",
            "deleter": null,
            "deleted_time": null,
            "languages": [
                "python"
            ],
            "tag": "TCA_Linux",
            "refer_scheme_info": null,
            "name": "默认",
            "description": null,
            "default_flag": true,
            "created_from": "web",
            "job_runtime_limit": 600,
            "ignore_merged_issue": false,
            "ignore_branch_issue": null,
            "ignore_submodule_clone": false,
            "ignore_submodule_issue": true,
            "issue_global_ignore": false,
            "daily_save": false,
            "lfs_flag": null,
            "webhook_flag": false,
            "issue_revision_merge_flag": false,
            "status": 1,
            "scheme_key": null,
            "repo": 1
        },
        "branch": "master",
        "status": 1,
        "created_from": "tca_web"
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定代码库的指定分析项目

```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/<project_id>/
```

#### 返回结果
```JSON
{
    "data": {
        "id":1,
        "creator": {
            "username": "username",
            "nickname": "nickname",
            "status": 1,
            "avatar": null,
            "org": 1
        },
        "created_time": "2021-01-28 02:27:26.256015+00:00",
        "modifier": null,
        "modified_time": "2021-01-28 02:27:26.256284+00:00",
        "deleter": null,
        "deleted_time": null,
        "repo": {
            "id": 1,
            "name": "test_demo.git",
            "scm_url": "http://github.com/xxxx/test_demo.git",
            "scm_type": "git",
            "scm_auth": {
                "id": 1,
                "scm_account": null,
                "scm_oauth": null,
                "scm_ssh": {
                    "id": 1,
                    "name": "1",
                    "scm_platform": 1,
                    "scm_platform_desc": null,
                    "user": {
                        "username": "username",
                        "nickname": "nickname",
                        "status": 1,
                        "avatar": null,
                        "org": 1
                    }
                },
                "auth_type": "ssh_token",
                "created_time": "2021-01-28T10:26:31.453389+08:00",
                "modified_time": "2021-01-28T10:26:31.453417+08:00"
            },
            "symbol": null
        },
        "scan_scheme": {
            "id": 1,
            "creator": {
                "username": "username",
                "nickname": "nickname",
                "status": 1,
                "avatar": null,
                "org": 1
            },
            "created_time": "2021-01-28 02:27:26.209661+00:00",
            "modifier": null,
            "modified_time": "2021-01-28 02:27:26.255023+00:00",
            "deleter": null,
            "deleted_time": null,
            "languages": [
                "python"
            ],
            "tag": "TCA_Linux",
            "refer_scheme_info": null,
            "name": "默认",
            "description": null,
            "default_flag": true,
            "created_from": "web",
            "job_runtime_limit": 600,
            "ignore_merged_issue": false,
            "ignore_branch_issue": null,
            "ignore_submodule_clone": false,
            "ignore_submodule_issue": true,
            "issue_global_ignore": false,
            "daily_save": false,
            "lfs_flag": null,
            "webhook_flag": false,
            "issue_revision_merge_flag": false,
            "status": 1,
            "scheme_key": null,
            "repo": 1
        },
        "branch": "master",
        "status": 1,
        "created_from": "tca_web"
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 查看指定代码库的扫描方案列表
```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| name | str | 扫描方案名称 |
| status | int | 扫描方案状态，1为活跃，2为废弃 |

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "creator": {
                    "username": "username",
                    "nickname": "nickname",
                    "status": 1,
                    "avatar": null,
                    "org": 1
                },
                "created_time": "2021-01-28 02:27:26.209661+00:00",
                "modifier": null,
                "modified_time": "2021-01-28 02:27:26.255023+00:00",
                "deleter": null,
                "deleted_time": null,
                "languages": [
                    "python"
                ],
                "tag": "TCA_Linux",
                "refer_scheme": null,
                "name": "默认",
                "description": null,
                "default_flag": true,
                "created_from": "web",
                "job_runtime_limit": 600,
                "ignore_merged_issue": false,
                "ignore_branch_issue": null,
                "ignore_submodule_clone": false,
                "ignore_submodule_issue": true,
                "issue_global_ignore": false,
                "daily_save": false,
                "lfs_flag": null,
                "issue_revision_merge_flag": false,
                "status": 1,
                "repo": 1
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 使用指定扫描方案模板创建指定代码库的扫描方案
```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/copyscheme/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| name | str | 扫描方案名称 |
| ref_scheme | int | 参照扫描方案编号 |

#### 返回结果
```JSON
{
    "data": {
        "scan_scheme": 1
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 201
}
```

## 查看指定代码库的指定扫描方案
```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/basicconf/
```

#### 返回结果
```JSON
{
    "data": {
        "id": 1,
        "creator": {
            "username": "username",
            "nickname": "nickname",
            "status": 1,
            "avatar": null,
            "org": 1
        },
        "created_time": "2021-01-28 02:27:26.209661+00:00",
        "modifier": null,
        "modified_time": "2021-01-28 02:27:26.255023+00:00",
        "deleter": null,
        "deleted_time": null,
        "languages": [
            "python"
        ],
        "tag": "TCA_Linux",
        "refer_scheme": null,
        "name": "默认",
        "description": null,
        "default_flag": true,
        "created_from": "web",
        "job_runtime_limit": 600,
        "ignore_merged_issue": false,
        "ignore_branch_issue": null,
        "ignore_submodule_clone": false,
        "ignore_submodule_issue": true,
        "issue_global_ignore": false,
        "daily_save": false,
        "lfs_flag": null,
        "issue_revision_merge_flag": false,
        "status": 1,
        "repo": 1
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```


## 更新指定代码库的指定方案
```
PUT /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/basicconf/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| languages | list | 代码语言 |
| tag | str | 执行标签，目前只支持 CodeDog_Linux |
| name | str | 方案名称 |
| description | str | 方案描述 |
| default_flag | bool | 默认方案标志，一个代码库只能有一个默认方案 |
| job_runtime_limit | int | 任务执行超时时间，默认为600分钟 |
| ignore_merged_issue | bool | 忽略合入的问题 |
| ignore_branch_issue | str | 过滤参考分支引入的问题 |
| ignore_submodule_clone | bool |  不拉取子模块扫描，True表示不拉取，False表示拉取 |
| ignore_submodule_issue | bool | 忽略子模块引入的问题，True表示忽略，False表示不忽略 |
| issue_global_ignore | bool | 问题全局忽略 |
| daily_save | bool | 每次扫描原始数据存储，默认存储7天 |
| lfs_flag | bool | 拉取lfs模块开关 |
| issue_revision_merge_flag | bool | "是否开启Issue按引入版本号聚合开关 |
| status | int | 方案状态，1表示活跃，2表示废弃|

#### 返回结果
同[查看指定代码库的指定扫描方案](查看指定代码库的指定扫描方案)的返回结果一致


## 查看指定代码库的扫描方案的代码扫描配置
```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/lintconf/
```
#### 返回结果
```JSON
{
    "data": {
        "id": 1,
        "enabled": true,
        "checkprofile": {
            "id": 1,
            "profile_type": 1,
            "custom_checkpackage": 1,
            "checkpackages": [
                1
            ]
        },
        "scan_scheme": 1
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```


## 更新指定代码库的指定方案的代码扫描配置
```
PUT /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/lintconf/
```

#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| enabled | bool | 是否开启代码扫描 |

#### 返回结果
同[指定代码库的指定方案的代码扫描配置](指定代码库的指定方案的代码扫描配置)的返回结果一致

## 查看指定代码库的扫描方案的代码度量配置
```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/metricconf/
```

####  返回结果
```JSON
{
    "data": {
        "id": 1,
        "cc_scan_enabled": false,
        "min_ccn": 20,
        "dup_scan_enabled": false,
        "dup_block_length_min": 120,
        "dup_block_length_max": null,
        "dup_min_dup_times": 2,
        "dup_max_dup_times": null,
        "dup_min_midd_rate": 5,
        "dup_min_high_rate": 11,
        "dup_min_exhi_rate": 20,
        "dup_issue_limit": 1000,
        "cloc_scan_enabled": false,
        "scan_scheme": 1
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 更新指定代码库的指定方案的代码度量配置
```
PUT /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/metricconf/
```

#### 参数列表

| 参数 | 类型 | 描述 |
| --- | --- | --- |
| cc_scan_enabled | bool | 圈复杂度扫描开关 |
| min_ccn | int | 最小圈复杂度 |
| dup_scan_enabled | bool | 重复代码扫描开关 |
| dup_block_length_min | int | 重复块最小长度 |
| dup_block_length_max | int | 重复块最大长度 |
| dup_max_dup_times | int | 最大重复次数 |
| dup_min_midd_rate | int | 中风险最小重复率 |
| dup_min_high_rate | int | 高风险最小重复率 |
| dup_min_exhi_rate | int | 极高风险风险最小重复率 |
| dup_issue_limit | int | 上报重复代码块数上限 |
| cloc_scan_enabled | boolean | 代码统计扫描开关 |

#### 返回结果
同[指定代码库的指定方案的代码度量配置](指定代码库的指定方案的代码度量配置)的返回结果一致

## 查看指定代码库的扫描方案的过滤路径列表
```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/scandirs/
```

#### 返回结果
```JSON
{
    "data": {
        "count": 1,
        "next": null,
        "previous": null,
        "results": [
            {
                "id": 1,
                "dir_path": "test/*",
                "path_type": 1,
                "scan_type": 1,
                "scan_scheme": 1
            }
        ]
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 创建指定代码库的指定方案的过滤路径列表
```
POST /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/scandirs/
```
#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| dir_path |str | 指定过滤路径 |
| path_type | int | 路径格式，1表示通配符，2表示正则表达式，默认为通配符 |
| scan_type | int | 扫描类型，1表示包含，2表示排除 |

#### 返回结果
```JSON
{
    "data": {
        "id": 13,
        "dir_path": "test/*.py",
        "path_type": 1,
        "scan_type": 1,
        "scan_scheme": 36
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 201
}
```


## 查看指定代码库的扫描方案的指定过滤路径
```
GET /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/scandirs/<dir_id>/
```

#### 返回结果
```JSON
{
    "data": {
        "id": 1,
        "dir_path": "test/*.py",
        "path_type": 1,
        "scan_type": 1,
        "scan_scheme": 1
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 200
}
```

## 更新指定代码库的指定方案的指定过滤路径
```
PUT /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/scandirs/<dir_id>/
```
#### 参数列表
| 参数 | 类型 | 描述 |
| --- | --- | --- |
| dir_path |str | 指定过滤路径 |
| path_type | int | 路径格式，1表示通配符，2表示正则表达式，默认为通配符 |
| scan_type | int | 扫描类型，1表示包含，2表示排除 |

#### 返回结果
```JSON
{
    "data": {
        "id": 13,
        "dir_path": "test/*.py",
        "path_type": 1,
        "scan_type": 1,
        "scan_scheme": 36
    },
    "code": 0,
    "msg": "请求成功",
    "status_code": 201
}
```

## 删除指定代码库的指定方案的指定过滤路径
```
DELETE /server/main/api/orgs/<org_sid>/teams/<team_name>/repos/<repo_id>/schemes/<scheme_id>/scandirs/<dir_id>/
```

#### 返回结果
无
