<p align="center">
    <img src='https://tencent.github.io/CodeAnalysis/media/Logo.png' width="200"/>
    <br />
    <em>腾讯云代码分析</em>
    <br />
    <em>代号：CodeDog</em>
</p>

[![license](https://img.shields.io/badge/License-MIT-brightgreen.svg?style=flat)](LICENSE.txt) [![docs](https://img.shields.io/badge/docs-read-brightgreen.svg?style=flat)](https://tencent.github.io/CodeAnalysis/)

[English](README.md) | [简体中文](README_ZH.md)

## TCA-官方

[官方网址：https://tca.tencent.com](https://tca.tencent.com)

[官方介绍：https://cloud.tencent.com/product/tcap](https://cloud.tencent.com/product/tcap)

## TCA-CNB代码库（境内）

[境内开源：https://cnb.cool/tca/code-analysis](https://cnb.cool/tca/code-analysis)

[境内开源：https://cnb.cool/tca](https://cnb.cool/tca)

## TCA-Github代码库（境外）

[境外开源：https://tencent.github.io/CodeAnalysis/](https://tencent.github.io/CodeAnalysis/)

[境外开源：https://github.com/TCATools](https://github.com/TCATools)

## TCA

腾讯云代码分析（Tencent Cloud Code Analysis，简称TCA，内部曾用研发代号CodeDog）是集众多分析工具的云原生、分布式、高性能的代码综合分析跟踪平台，包含服务端、Web端和客户端三个组件，已集成一批自研工具，同时也支持动态集成业界各编程语言的分析工具。

代码分析是通过词法分析、语法分析、控制流、数据流分析等技术对程序代码进行扫描，对代码进行综合分析，验证代码是否满足规范性、安全性、可靠性、可维护性等指标的一种代码分析技术。

使用TCA可以帮助团队用代码分析技术查找代码中的规范性、结构性、安全漏洞等问题，持续监控项目代码质量并进行告警。同时TCA开放API，支持与上下游系统对接，从而集成代码分析能力，为代码质量提供保障，更有益于传承优良的团队代码文化。  

![组件图](https://tencent.github.io/CodeAnalysis/media/Components.png)

![流程图](https://tencent.github.io/CodeAnalysis/media/Flow.png)

## 关键功能

1. **语言支持**：支持 Java/C++/Objective-C/C#/JavaScript/Python/Go/PHP 等数十种语言，覆盖常用编程语言。
2. **代码检查**：通过代码分析精准跟踪管理发现的代码质量缺陷、代码规范问题、代码安全漏洞、无效代码等。目前已集成众多自研、知名开源分析工具，并采用了分层分离架构，可以支持团队快速自助管理工具。
3. **代码度量**：支持代码圈复杂度、代码重复率和代码统计三个维度对代码进行综合度量。
4. **DevOps集成**：客户端通过命令行启动方式，通过标准API接口对接上下游系统，可以快速对接各个DevOps调度体系。

## 快速入门

- [快速部署](https://tencent.github.io/CodeAnalysis/zh/quickStarted/)
- [如何使用TCA Action快速体验](https://github.com/TCATools/TCA-action/blob/main/README.md)
- [如何使用客户端](https://tencent.github.io/CodeAnalysis/zh/guide/客户端/本地分析.html)

## 社区

- 微信公众号：「腾讯云静态分析」，关注并发送“进群”即可加入官方开源交流微信群
- 微信群金牌🏅服务群：

    <img src='https://tencent.github.io/CodeAnalysis/media/WechatQRCode.png' width="200"/>

- QQ交流群：361791391  
- [GitHub讨论区](https://github.com/Tencent/CodeAnalysis/discussions)
- [Wiki](https://github.com/Tencent/CodeAnalysis/wiki)
- [腾讯云代码分析白皮书](腾讯云代码分析白皮书.pdf)

## 更新

[Changelog](CHANGELOG.md)

## 贡献

- 查看我们的[贡献说明](CONTRIBUTING.md)
- [腾讯开源摘星计划2022](https://github.com/weopenprojects/WeOpen-Star/issues/19#issue-1228583868)（活动时间：2022年5月~12月）
- [腾讯开源激励计划](https://opensource.tencent.com/contribution) 鼓励开发者的参与和贡献，期待你的加入

## 许可

TCA 使用 [MIT 许可证](LICENSE.txt)

### TCA 团队成员

![腾讯云代码分析团队成员](https://tencent.github.io/CodeAnalysis/media/TeamMembers.png)