# 第七章 动态渲染页面抓取

在前一章中，我们了解了 Ajax 的分析和抓取方式，这其实也是 JavaScript 动态渲染的页面的一种情形，通过直接分析 Ajax，我们仍然可以借助 requests 或 urllib 来实现数据爬取。

不过 JavaScript 动态渲染的页面不止 Ajax 这一种。比如中国青年网（详见 [http://news.youth.cn/gn/](http://news.youth.cn/gn/)），它的分页部分是由 JavaScript 生成的，并非原始 HTML 代码，这其中并不包含 Ajax 请求。比如 ECharts 的官方实例（详见 [http://echarts.baidu.com/demo.html](http://echarts.baidu.com/demo.html)），其图形都是经过 JavaScript 计算之后生成的。再有淘宝这种页面，它即使是 Ajax 获取的数据，但是其 Ajax 接口含有很多加密参数，我们难以直接找出其规律，也很难直接分析 Ajax 来抓取。

为了解决这些问题，我们可以直接使用模拟浏览器运行的方式来实现，这样就可以做到在浏览器中看到是什么样，抓取的源码就是什么样，也就是可见即可爬。这样我们就不用再去管网页内部的 JavaScript 用了什么算法渲染页面，不用管网页后台的 Ajax 接口到底有哪些参数。

Python 提供了许多模拟浏览器运行的库，如 Selenium、Splash、PyV8、Ghost 等。本章中，我们就来介绍一下 Selenium 和 Splash 的用法。有了它们，就不用再为动态渲染的页面发愁了。