# 15.2 Scrapyd-Client 的使用

这里有现成的工具来完成部署过程，它叫作 Scrapyd-Client。本节将简单介绍使用 Scrapyd-Client 部署 Scrapy 项目的方法。

### 1. 准备工作

请先确保 Scrapyd-Client 已经正确安装，安装方式可以参考第 1 章的内容。

### 2. Scrapyd-Client 的功能

Scrapyd-Client 为了方便 Scrapy 项目的部署，提供两个功能：
* 将项目打包成 Egg 文件。
* 将打包生成的 Egg 文件通过 addversion.json 接口部署到 Scrapyd 上。

也就是说，Scrapyd-Client 帮我们把部署全部实现了，我们不需要再去关心 Egg 文件是怎样生成的，也不需要再去读 Egg 文件并请求接口上传了，这一切的操作只需要执行一个命令即可一键部署。

### 3. Scrapyd-Client 部署

要部署 Scrapy 项目，我们首先需要修改一下项目的配置文件，例如我们之前写的 Scrapy 微博爬虫项目，在项目的第一层会有一个 scrapy.cfg 文件，它的内容如下：

```ini
[settings]
default = weibo.settings

[deploy]
#url = http://localhost:6800/
project = weibo
```
在这里我们需要配置一下 deploy 部分，例如我们要将项目部署到 120.27.34.25 的 Scrapyd 上，就需要修改为如下内容：
```ini
[deploy]
url = http://120.27.34.25:6800/
project = weibo
```
这样我们再在 scrapy.cfg 文件所在路径执行如下命令：
```
scrapyd-deploy
```
运行结果如下：
```
Packing version 1501682277
Deploying to project "weibo" in http://120.27.34.25:6800/addversion.json
Server response (200):
{"status": "ok", "spiders": 1, "node_name": "datacrawl-vm", "project": "weibo", "version": "1501682277"}
```

返回这样的结果就代表部署成功了。

我们也可以指定项目版本，如果不指定的话默认为当前时间戳，指定的话通过 version 参数传递即可，例如：

```
scrapyd-deploy --version 201707131455
```

值得注意的是在 Python3 的 Scrapyd 1.2.0 版本中我们不要指定版本号为带字母的字符串，需要为纯数字，否则可能会出现报错。

另外如果我们有多台主机，我们可以配置各台主机的别名，例如可以修改配置文件为：

```ini
[deploy:vm1]
url = http://120.27.34.24:6800/
project = weibo

[deploy:vm2]
url = http://139.217.26.30:6800/
project = weibo
```
有多台主机的话就在此统一配置，一台主机对应一组配置，在 deploy 后面加上主机的别名即可，这样如果我们想将项目部署到 IP 为 139.217.26.30 的 vm2 主机，我们只需要执行如下命令：
```
scrapyd-deploy vm2
```

这样我们就可以将项目部署到名称为 vm2 的主机上了。

如此一来，如果我们有多台主机，我们只需要在 scrapy.cfg 文件中配置好各台主机的 Scrapyd 地址，然后调用 scrapyd-deploy 命令加主机名称即可实现部署，非常方便。

如果 Scrapyd 设置了访问限制的话，我们可以在配置文件中加入用户名和密码的配置，同时端口修改一下，修改成 Nginx 代理端口，如在第一章我们使用的是 6801，那么这里就需要改成 6801，修改如下：

```ini
[deploy:vm1]
url = http://120.27.34.24:6801/
project = weibo
username = admin
password = admin

[deploy:vm2]
url = http://139.217.26.30:6801/
project = weibo
username = germey
password = germey
```

这样通过加入 username 和 password 字段我们就可以在部署时自动进行 Auth 验证，然后成功实现部署。

### 4. 结语

本节介绍了利用 Scrapyd-Client 来方便地将项目部署到 Scrapyd 的过程，有了它部署不再是麻烦事。