# 第十章 模拟登录

很多情况下，页面的某些信息需要登录才可以查看。对于爬虫来说，需要爬取的信息如果需要登录才可以看到的话，那么我们就需要做一些模拟登录的事情。

在前面我们了解了会话和 Cookies 的用法。简单来说，打开网页然后模拟登录，这实际上是在客户端生成了 Cookies，而 Cookies 里面保存了 SessionID 的信息，登录之后的后续请求都会携带生成后的 Cookies 发送给服务器。服务器就会根据 Cookies 判断出对应的 SessionID，进而找到会话。如果当前会话是有效的，那么服务器就判断用户当前已经登录了，返回请求的页面信息，这样我们就可以看到登录之后的页面。

这里的核心就是获取登录之后的 Cookies。而要获取 Cookies，我们可以手动在浏览器里输入用户密码，然后再把 Cookies 复制下来，但是这样做明显会增加人工工作量。爬虫的目的不就是自动化吗？所以我们要做的就是用程序来完成这个过程，也就是用程序模拟登录。

接下来，我们将介绍模拟登录的相关方法以及如何维护一个 Cookies 池。