## 1.6　Web 库的安装

对于 Web，我们应该都不陌生，现在日常访问的网站都是 Web 服务程序搭建而成的。Python 同样不例外，也有一些这样的 Web 服务程序，比如 Flask、Django 等，我们可以拿它来开发网站和接口等。

在本书中，我们主要使用这些 Web 服务程序来搭建一些 API 接口，供我们的爬虫使用。例如，维护一个代理池，代理保存在 Redis 数据库中，我们要将代理池作为一个公共的组件使用，那么如何构建一个方便的平台来供我们获取这些代理呢？最合适不过的就是通过 Web 服务提供一个 API 接口，我们只需要请求接口即可获取新的代理，这样做简单、高效、实用！

书中用到的一些 Web 服务程序主要有 Flask 和 Tornado，这里就分别介绍它们的安装方法。

### 1.6.1 Flask 的安装

Flask 是一个轻量级的 Web 服务程序，它简单、易用、灵活，这里主要用来做一些 API 服务。

#### 1. 相关链接

* GitHub：[https://github.com/pallets/flask](https://github.com/pallets/flask)
* 官方文档：[http://flask.pocoo.org](http://flask.pocoo.org)
* 中文文档：[http://docs.jinkan.org/docs/flask](http://docs.jinkan.org/docs/flask)
* PyPI：[https://pypi.python.org/pypi/Flask](https://pypi.python.org/pypi/Flask)

#### 2. pip 安装

这里推荐使用 pip 安装，命令如下：

```
pip3 install flask
```

运行完毕后，就完成安装了。

#### 3. 验证安装

安装成功后，可以运行如下实例代码测试一下：

```python
from flask import Flask
app = Flask(__name__)

@app.route("/")
def hello():
    return "Hello World!"

if __name__ == "__main__":
    app.run()
```
可以发现，系统会在 5000 端口开启 Web 服务，控制台输出如下：
```
* Running on http://127.0.0.1:5000/ (Press CTRL+C to quit)
```
直接访问 [http://127.0.0.1:5000/](http://127.0.0.1:5000/)，可以观察到网页中呈现了 Hello World!，如图 1-40 所示，一个最简单的 Flask 程序就运行成功了。

![](./assets/1-40.png)

图 1-40　运行结果

#### 4. 结语

后面，我们会利用 Flask + Redis 维护动态代理池和 Cookies 池。

### 1.6.2　Tornado 的安装

Tornado 是一个支持异步的 Web 框架，通过使用非阻塞 I/O 流，它可以支撑成千上万的开放连接，效率非常高，本节就来介绍一下它的安装方式。

#### 1. 相关链接

* GitHub：[https://github.com/tornadoweb/tornado](https://github.com/tornadoweb/tornado)
* PyPI：[https://pypi.python.org/pypi/tornado](https://pypi.python.org/pypi/tornado)
* 官方文档：[http://www.tornadoweb.org](http://www.tornadoweb.org)

#### 2. pip 安装

这里推荐使用 pip 安装，相关命令如下：

```
pip3 install tornado
```

执行完毕后，即可完成安装。

#### 3. 验证安装

同样，这里也可以用一个 Hello World 程序测试一下，代码如下：

```python
import tornado.ioloop
import tornado.web

class MainHandler(tornado.web.RequestHandler):
    def get(self):
        self.write("Hello, world")

def make_app():
    return tornado.web.Application([(r"/", MainHandler),
    ])

if __name__ == "__main__":
    app = make_app()
    app.listen(8888)
    tornado.ioloop.IOLoop.current().start()
```

直接运行程序，可以发现系统在 8888 端口运行了 Web 服务，控制台没有输出内容，此时访问 http://127.0.0.1:8888/，可以观察到网页中呈现了 Hello,world，如图 1-41 所示，这就说明 Tornado 成功安装了。

![](./assets/1-41.png)

图 1-41　运行结果

#### 4. 结语

后面，我们会利用 Tornado + Redis 来搭建一个 ADSL 拨号代理池。