## 1.5　存储库的安装

1.4 节中，我们介绍了几个数据库的安装方式，但这仅仅是用来存储数据的数据库，它们提供了存储服务，但如果想要和 Python 交互的话，还需要安装一些 Python 存储库，如 MySQL 需要安装 PyMySQL，MongoDB 需要安装 PyMongo 等。本节中，我们来说明一下这些存储库的安装方式。

### 1.5.1　PyMySQL  的安装

在 Python 3 中，如果想要将数据存储到 MySQL 中，就需要借助 PyMySQL 来操作，本节中我们介绍一下它的安装方式。

#### 1. 相关链接

* GitHub：[https://github.com/PyMySQL/PyMySQL](https://github.com/PyMySQL/PyMySQL)
* 官方文档：[http://pymysql.readthedocs.io/](http://pymysql.readthedocs.io/)
* PyPI：[https://pypi.python.org/pypi/PyMySQL](https://pypi.python.org/pypi/PyMySQL)

#### 2. pip 安装

这里推荐使用 pip 安装，命令如下：

```
pip3 install pymysql
```

执行完命令后即可完成安装。

#### 3. 验证安装

为了验证库是否已经安装成功，可以在命令行下测试一下。这里首先输入 python3，进入命令行模式，接着输入如下内容：

```python
$ python3
>>> import pymysql
>>> pymysql.VERSION
(0, 7, 11, None)
>>> 
```

如果成功输出了其版本内容，那么证明 PyMySQL 成功安装。

### 1.5.2　PyMongo 的安装

在 Python 中，如果想要和 MongoDB 进行交互，就需要借助于 PyMongo 库，这里就来了解一下它的安装方法。

#### 1. 相关链接

* GitHub：[https://github.com/mongodb/mongo-python-driver](https://github.com/mongodb/mongo-python-driver)
* 官方文档：[https://api.mongodb.com/python/current/](https://api.mongodb.com/python/current/)
* PyPI：[https://pypi.python.org/pypi/pymongo](https://pypi.python.org/pypi/pymongo)

#### 2. pip 安装

这里推荐使用 pip 安装，命令如下：

```
pip3 install pymongo
```

运行完毕之后，即可完成 PyMongo 的安装。

#### 3. 验证安装

为了验证 PyMongo 库是否已经安装成功，可以在命令行下测试一下：

```python
$ python3
>>> import pymongo
>>> pymongo.version
'3.4.0'
>>> 
```

如果成功输出了其版本内容，那么证明成功安装。

### 1.5.3　redis-py 的安装

对于 Redis 来说，我们要使用 redis-py 库来与其交互，这里就来介绍一下它的安装方法。

#### 1. 相关链接

* GitHub：[https://github.com/andymccurdy/redis-py](https://github.com/andymccurdy/redis-py)
* 官方文档：[https://redis-py.readthedocs.io/](https://redis-py.readthedocs.io/)

#### 2. pip 安装

这里推荐使用 pip 安装，命令如下：

```
pip3 install redis
```

运行完毕之后，即可完成 redis-py 的安装。

#### 3. 验证安装

为了验证 redis-py 库是否已经安装成功，可以在命令行下测试一下：

```python
$ python3
>>> import redis
>>> redis.VERSION
(2, 10, 5)
>>> 
```

如果成功输出了其版本内容，那么证明成功安装了 redis-py。

### 1.5.4　RedisDump 的安装

RedisDump 是一个用于 Redis 数据导入 / 导出的工具，是基于 Ruby 实现的，所以要安装 RedisDump，需要先安装 Ruby。

#### 1. 相关链接


* GitHub：[https://github.com/delano/redis-dump](https://github.com/delano/redis-dump)
* 官方文档：[http://delanotes.com/redis-dump](http://delanotes.com/redis-dump)

#### 2. 安装 Ruby

有关 Ruby 的安装方式可以参考 [http://www.ruby-lang.org/zh_cn/documentation/installation](http://www.ruby-lang.org/zh_cn/documentation/installation)，这里列出了所有平台的所有安装方式，可以根据对应的平台选用合适的安装方式。

#### 3. gem 安装

安装完成之后，就可以执行 gem 命令了，它类似于 Python 中的 pip 命令。利用 gem 命令，我们可以安装 RedisDump，具体如下：

```
gem install redis-dump
```

执行完毕之后，即可完成 RedisDump 的安装。

#### 4. 验证安装

安装成功后，就可以执行如下两个命令：

```
redis-dump  
redis-load
```

如果可以成功调用，则证明安装成功。