.
├── DeepSeek
│   ├── App
│   │   ├── AppEntryView.swift
│   │   └── DeepSeekApp.swift
│   ├── Core
│   │   ├── Network
│   │   │   ├── ChooseStyles.swift
│   │   │   ├── DeepSeekAPI.swift
│   │   │   ├── DeepSeekService.swift
│   │   │   └── DeepSeekServiceConfiguration.swift
│   │   ├── Services
│   │   │   ├── Clipboard.swift
│   │   │   ├── Haptics.swift
│   │   │   ├── PromptManager.swift
│   │   │   ├── SamplePrompts.swift
│   │   │   ├── SpeechSynthesizer.swift
│   │   │   └── ThemeManager.swift
│   │   ├── Utils
│   │   │   ├── AppColors.swift
│   │   │   ├── ChatFilter.swift
│   │   │   ├── ChatGrouper.swift
│   │   │   └── Extensions
│   │   │       ├── Button+Extension.swift
│   │   │       ├── Date+Extension.swift
│   │   │       ├── JSON+Extension.swift
│   │   │       ├── SplashSyntaxHighlighter+Extension.swift
│   │   │       └── View+Extension.swift
│   │   └── ViewModifiers
│   │       └── RunningBorderViewModifier.swift
│   ├── Data
│   │   ├── Models
│   │   │   ├── ChatCheckBalance.swift
│   │   │   ├── ChatMessageModel.swift
│   │   │   ├── ChatServicesModel.swift
│   │   │   └── Prompt.swift
│   │   ├── Stores
│   │   │   ├── AppContainer.swift
│   │   │   ├── ChatStore.swift
│   │   │   └── PromptStore.swift
│   │   └── SwiftData
│   │       ├── Chat.swift
│   │       ├── ChatMessage.swift
│   │       └── Prompts.swift
│   ├── Extensions
│   ├── Features
│   │   ├── Chat
│   │   │   ├── HomeView.swift
│   │   │   ├── ViewModels
│   │   │   └── Views
│   │   │       ├── ChatInputView.swift
│   │   │       ├── ChatListView.swift
│   │   │       ├── ChatMessageView.swift
│   │   │       ├── ChatView.swift
│   │   │       ├── PromptChooseView.swift
│   │   │       └── PromptDetailView.swift
│   │   ├── Components
│   │   │   ├── BlurredBackgroundView.swift
│   │   │   ├── CodeBlockView.swift
│   │   │   ├── EmptyConversaitonView.swift
│   │   │   ├── LoadingView.swift
│   │   │   ├── MarkdownColours.swift
│   │   │   └── ReadingAloudView.swift
│   │   ├── Setting
│   │   │   └── Views
│   │   │       ├── PromptSettingView.swift
│   │   │       ├── SettingView.swift
│   │   │       ├── SpeechSettingView.swift
│   │   │       └── ThemeSettingView.swift
│   │   └── Sidebar
│   │       ├── Components
│   │       │   ├── BottomBarView.swift
│   │       │   └── EmptySearchResultView.swift
│   │       ├── Models
│   │       │   └── SidebarSection.swift
│   │       └── Views
│   │           ├── ChatSectionListView.swift
│   │           └── SidebarView.swift
│   ├── Managers
│   │   └── PromptManager.swift
│   ├── Preview Content
│   │   ├── ChatSamples.swift
│   │   ├── ChatStoreSamples.swift
│   │   ├── Preview Assets.xcassets
│   │   │   └── Contents.json
│   │   └── Preview.swift
│   └── Resources
│       └── Assets.xcassets
│           ├── AccentColor.colorset
│           │   └── Contents.json
│           ├── AppIcon.appiconset
│           │   └── Contents.json
│           ├── Contents.json
│           └── backgroundImage.colorset
│               └── Contents.json
├── DeepSeek.xcodeproj
│   ├── project.pbxproj
│   ├── project.xcworkspace
│   │   ├── contents.xcworkspacedata
│   │   ├── xcshareddata
│   │   │   ├── IDEWorkspaceChecks.plist
│   │   │   └── swiftpm
│   │   │       ├── Package.resolved
│   │   │       └── configuration
│   │   └── xcuserdata
│   │       └── apple.xcuserdatad
│   │           └── UserInterfaceState.xcuserstate
│   └── xcuserdata
│       └── apple.xcuserdatad
│           ├── xcdebugger
│           │   └── Breakpoints_v2.xcbkptlist
│           └── xcschemes
│               └── xcschememanagement.plist
├── Picture
│   ├── Attach.png
│   ├── Conversation.png
│   ├── Home.png
│   ├── Menu.png
│   ├── Prompt.png
│   └── Setting.png
├── README.md
└── TREE.md

45 directories, 77 files
