
# TCMLLM: 中医药大模型


   中医药大语言模型项目（TCMLLM）拟通过大模型方式实现中医临床辅助诊疗（病证诊断、处方推荐等）中医药知识问答等任务，推动中医知识问答、临床辅助诊疗等领域的快速发展。

   目前针对中医临床智能诊疗问题中的处方推荐任务，发布了中医处方推荐指令微调大模型TCMLLM-PR。


## TCMLLM-PR 面向中医处方推荐的大模型

本项目针对中医临床智能诊疗问题中的处方推荐任务，通过整合真实世界临床病历、医学典籍与中医教科书等数据，构建了包含68k数据条目（共10M token）的处方推荐指令微调数据集，并使用此数据集，在ChatGLM大模型上进行大规模指令微调，最终得到了中医处方推荐大模型TCMLLM-PR。


### 更新日志
**[2023/08/01] 面向处方推荐的大模型TCMLLM-PR**

[2023/06] 项目启动

### A Quick Start

1. 首先需要下载[ChatGLM-6B](https://github.com/THUDM/ChatGLM-6B)原始模型代码和参数，并配置依赖环境
2. 下载 TCMLLM 模型参数，将checkpoint压缩文件解压到 ChatGLM-6B/ptuning/ 路径下
 + 百度网盘链接: https://pan.baidu.com/s/1QFx-206Ww9Xt-7_Z0RF85g 提取码: iwg3 


  
### 指令微调数据集


#### 数据集介绍

   本项目构建的指令微调数据集包含8个数据来源，涵盖4本中医经典教科书《中医内科学》、《中医外科学》、《中医妇科学》和《中医儿科学》（即“内外妇儿”，**I**nternal medicine，**S**urgery， **G**ynecology，**P**ediatrics，简称ISGP）、2020版中国药典（**Ch**inese **p**harmacopeia，简称CHP）、中医临床经典医案数据（**C**hinese **M**edicine **C**linical **C**ases，简称CMCC）、以及多个三甲医院的涵盖肺病（简称Lung）、中风病（简称Stroke）、糖尿病（简称Diabetes）、肝病（简称Liver）、脾胃病（Splenic and stomach diseases，简称SSD）等多病种的临床病历数据。8个数据集共68k条，token总数约为10M（输入token总数为5M、输出token总数为4M），统计信息如下表。

<table>
	<tr>
        <th>类型</th>
	    <th>名称</th>
	    <th>简称</th>
		<th>数量</th>
		<th>来源</th>
		<th>输入token总数</th>
		<th>输出token总数</th>
		<th>token总数</th>
	</tr>
	<tr>
	    <td rowspan="3">知识</td>
	    <td>内外妇儿</td><td>ISGP</td><td>2k</td><td>中医4本教材</td><td>218k</td><td>75k</td><td>294k</td>
	</tr>
	<tr>
		<td>药典</td><td>CHP</td><td>1k</td><td>中国药典2020版</td><td>85k</td><td>50k</td><td>136k</td>
	</tr>
	<tr>
		<td>医案</td><td>CMCC</td><td>15k</td><td>临床经典医案</td><td>163k</td><td>613k</td><td>225k</td>
	</tr>
	<tr>
		<td rowspan="6">临床</td>
	</tr>
	<tr>
		<td>肺病</td><td>Lung</td><td>15k</td><td>中医医院1</td><td>755k</td><td>849k</td><td>160k</td>
	</tr>
	<tr>
		<td>中风病</td><td>Stroke</td><td>5k</td><td>中医医院2</td><td>298k</td><td>294k</td><td>593k</td>
	</tr>
	<tr>
		<td>糖尿病</td><td>Diabetes</td><td>8k</td><td>中医医院3</td><td>494k</td><td>262k</td><td>756k</td>
	</tr>
	<tr>
		<td>肝病</td><td>Liver</td><td>2k</td><td>中医医院4</td><td>86k</td><td>116k</td><td>202k</td>
	</tr>
	<tr>
		<td>脾胃病</td><td>SSD</td><td>17k</td><td>中医医院5</td><td>2M</td><td>2M</td><td>4M</td>
	</tr>
	<tr>
		<td>总计</td><td></td><td>Mixed</td><td>68K</td><td></td><td>5M</td><td>4M</td><td>10M</td>
	</tr>

</table>



#### 数据集示例

1. 中风病数据集示例
```
{"Content":"请根据中风病患者的症状信息进行中医处方推荐。肢体活动不利,言语不利,肢体麻木,烦躁,口苦,口干,便秘","Summary":"白僵蚕,炒白术,炒枳壳,刺蒺藜,大黄,当归,葛根,钩藤,厚朴,黄芪,菊花,牡蛎,片姜黄,全蝎,石决明,石菖蒲,首乌藤,酸枣仁,天麻,盐杜仲,郁金,远志,茯神,槲寄生"}
```
2. 经典教材（内外妇儿）数据集示例
```
{"Content":"请根据患者的症状信息进行中医处方推荐。恶寒,发热,无汗,头痛,肢体酸楚,鼻塞,声重,打喷嚏,鼻流清涕,咽痒,咳嗽,痰色白,痰稀薄,舌苔白,舌苔薄,脉浮,脉紧,恶寒甚", "Summary":"荆芥,防风,茯苓,独活,柴胡,前胡,川芎,枳壳,羌活,桔梗,薄荷,甘草"}
```
3. 药典数据集示例
```
{"Content":"请根据患者的症状信息进行中医处方推荐。燥热蕴肺所致的咳嗽、痰黄而黏不易咳出、胸闷气促、久咳不止、声哑喉痛","Summary":"川贝母,知母,石膏,炒栀子,黄芩,蜜桑白皮,茯苓,炒瓜蒌子,陈皮,麸炒枳实,炙甘草,五味子"}
```

### 训练细节

#### 计算资源需求

+ 训练阶段：TCMLLM-PR在两张3090显卡（24G显存*2）上完成训练。batch_size=16情况下单卡显存占用约23G，建议根据显存大小来调整batch_size。
+ 推理阶段：显存占用约为14G。


### 模型效果对比
 <table>
    <tr>
        <td width="400"><b>Question</b></td>
        <td width="400"><b>ChatGPT输出</b></td>
        <td width="400"><b>通义千问输出</b></td>
        <td width="400"><b>TCMLLM-PR输出</b></td>
        <td width="400"><b>Human</b></td>
    </tr>
    <tr>
        <td>请根据中风病患者的症状信息进行中医处方推荐。口角歪斜,吞咽呛咳,肢体活动不利,不能持物,不能行走,头晕,胸闷,干咳,日常生活能力重度下降</td>
      <td>白芍,<b>甘草</b>,生姜,大枣,桂枝,生薏苡仁,蜂蜜,人参,黄精,<b>党参</b>,白术,<b>茯苓</b>,熟地,山药,枸杞子,巴戟天,麦冬,陈皮,黄芩,连翘,金银花,银杏叶,红参,黄连等</td>
      <td>黄芪,当归,白术,地龙,<b>全蝎</b>,蜈蚣,桃仁,红花,赤芍,姜黄</td>
      <td><b>白僵蚕,炒白术,穿山甲,胆南星,党参,独活,防风,甘草,瓜蒌,红曲,化橘红,姜半夏,全蝎,石菖蒲,天麻,郁金,竹茹,茯苓</b></td>
      <td><b>白僵蚕,炒白术,穿山甲,胆南星,党参,独活,防风,甘草,瓜蒌,红曲,化橘红,姜半夏,全蝎,石菖蒲,天麻,郁金,竹茹,茯苓</b></td>
    </tr>
    <tr>
        <td>请根据中风病患者的症状信息进行中医处方推荐。肢体活动不利,肢体麻木,头晕,心慌,视物不清,痰少,痰白,眠差</td>
      <td>桂枝,芍药,甘草,生姜,大枣,半夏,人参,黄芩,当归,麦冬,陈皮,白术,木通,<b>茯苓</b>,枳实,川芎,越婢</td>
      <td>川芎,当归,白芍,细辛,黄芪,党参,灸甘草,地龙,<b>全蝎,红花,桃仁</b>,红参,<b>茯苓</b>,桂枝,白术,泽泻</td>
      <td><b>川贝母,胆南星,甘草,红花,红曲,化橘红,鸡血藤,姜半夏,全蝎,桑枝,石菖蒲,桃仁,郁金,远志,竹茹,茯苓</b></td>
      <td><b>川贝母,胆南星,甘草,红花,红曲,化橘红,鸡血藤,姜半夏,全蝎,桑枝,石菖蒲,酸枣仁,桃仁,郁金,远志,竹茹,茯苓</b></td>
    </tr>
    <tr>
        <td>请根据患者的症状信息进行中医处方推荐。心悸,气短,头晕,目眩,失眠,健忘,面色无华,倦怠,乏力,纳呆,食少,舌淡,舌红,脉细,脉弱,阳虚而汗出肢冷</td>
      <td><b>人参</b>,黄芪,麦冬,枸杞子,熟地黄,<b>当归,白术</b>,茯苓,陈皮,天麻,龙骨,牡蛎,<b>酸枣仁,远志</b>,丹参,川芎,<b>生姜,大枣</b></td>
      <td>黄芪,桂枝,白芍,<b>生姜</b>,大枣</td>
      <td>黄芪,<b>白术,当归,茯神,酸枣仁,远志,龙眼肉,炙甘草,木香,大枣</b></td>
      <td><b>白术,当归,茯神,炙黄芪,龙眼肉,远志,酸枣仁,木香,炙甘草,人参,生姜,大枣</b></td>
    </tr>
    <tr>
        <td>请根据患者的症状信息进行中医处方推荐。小便黄赤,小便灼热,尿血,心烦,口渴,面赤,口疮,夜寐不安,舌质红,脉数,尿血较甚</td>
      <td>黄柏,泽泻,车前草,丹参,金银花,生<b>地黄<b>,丝瓜络,玄参,天花粉,茯苓,<b>甘草</b></td>
        <td>黄连,黄芩,黄柏,萆薢,萹蓄,瞿麦,<b>滑石,甘草</b></td>
        <td><b>小蓟,地黄,滑石,木通,蒲黄,藕节,淡竹叶</b>,黄芩,<b>甘草</b></td>
        <td><b>小蓟,地黄,滑石,木通,蒲黄,藕节,淡竹叶,当归,栀子,甘草</b></td>
    </tr>
    <tr>
        <td>请根据肺病患者的症状信息进行中医处方推荐。大便困难,水肿,有喘息中,痛苦面容,气短,双侧鼻腔通畅,鼻翼煽动,皮肤未见出血点及蜘蛛痣,胸闷,双输尿管压痛点无明显压痛,肺部叩诊清音,咳嗽,头颅无压痛,腰酸,可闻及干湿性啰音,心脏震颤,纳差,咳痰,气喘,易感冒,下肢酸胀,头晕,尿频,精神不振,双肺呼吸音粗</td>
      <td>杏仁,瓜蒌,<b>桔梗</b>,苏叶,葶苈子,<b>半夏,黄芩,生甘草,川贝母</b>,白芍,制附子</td>
      <td>葶苈子,大枣,<b>桑白皮</b>,杏仁,<b>黄芩</b>,党参,甘草,猪苓,茯苓,泽泻,黄芪,桂枝,白芍,生姜,白术,<b>炙甘草</b>,当归,升麻,柴胡</td>
      <td><b>桑白皮</b>,茯苓,<b>陈皮,山药</b>,半夏,<b>紫菀,苦杏仁,地龙,白前,白果仁,</b>瓦楞子,<b>桔梗,款冬花,贝母,前胡,麻黄,射干,甘草,</b>罂粟壳,黄芪,<b>百部</b></td>
      <td><b>桑白皮,山药,陈皮,半夏,黄芩,紫菀,苦杏仁,地龙,白前,白果仁,桔梗,款冬花,贝母,前胡,麻黄,射干,甘草,百部</b></td>
    </tr>
    <tr>
        <td>请根据肺病患者的症状信息进行中医处方推荐。双肺呼吸音粗,气喘,眠差,严重影响休息及日常活动,呼吸困难,咳嗽,胸闷,咳痰</td>
      <td><b>桔梗</b>,杏仁,<b>炙甘草</b>,生姜片,麻杏,石膏,黄连,黄芩,<b>陈皮</b>,干姜</td>
      <td>黄芪,党参,白术,茯苓,<b>甘草</b>,当归,<b>陈皮</b>,<b>半夏,</b>枳壳,杏仁,<b>黄芩</b>,黄连,石膏,知母,杏仁,<b>桑白皮</b>,葶苈子,地骨皮,芦根,<b>百部</b>,<b>款冬花</b>,地骨皮,五味子,川<b>贝母</b></td>
      <td><b>桑白皮,陈皮,半夏,黄芩,紫菀,苦杏仁,瓜蒌,白前,桔梗,款冬花,贝母,前胡,麻黄,射干,金荞麦,甘草,罂粟壳,百部</b></td>
      <td><b>桑白皮,陈皮,半夏,黄芩,紫菀,苦杏仁,瓜蒌,地龙,白前,白果仁,桔梗,款冬花,贝母,前胡,麻黄,射干,金荞麦,甘草,百部</b></td>
    </tr>
    <tr>
        <td>请根据肝病患者的症状信息进行中医处方推荐。乏力,腹胀,肝区不适,倦怠,纳差,身目尿黄,小便深黄</td>
        <td>柴胡,白芍,泽泻,枳实,甘草</td>
      <td>黄连,黄芩,白术,<b>茵陈</b>,板蓝根,猪苓,泽泻,枸杞子,女贞子,菊花,生地黄</td>
      <td><b>牡蛎,莪术,薏苡仁,郁金,连翘,瓦楞子,</b>鸡内金,<b>丹参</b>,半枝莲,白花蛇舌草,<b>鳖甲</b></td>
      <td><b>郁金,瓦楞子,地丁,槟榔,车前子,薏苡仁,莪术,丹参,连翘,茵陈,鳖甲,牡蛎,赤芍</b></td>
    </tr>
    <tr>
        <td>请根据脾胃病患者的症状信息进行中医处方推荐。反酸,嗳气,烧心,胃痛,时胃胀,胃寒,大便调,午后易饥饿,入睡困难,做梦,乏力,情绪急躁,易上火,易感冒,畏风,畏寒,舌胖,质淡暗,苔薄白腻,脉沉细</td>
      <td>人参,<b>白术</b>,茯苓,砂仁,<b>甘草</b>,大枣,<b>陈皮</b>,<b>枳壳</b>,泽泻,莱菔子,丹皮,苍术,草果,山楂,木香,香附,附子（煅）,干姜,大茴</td>
      <td>苍术,厚朴,<b>陈皮</b>,半夏,黄连,黄芩,生姜,大枣,附子,肉桂</td>
      <td><b>柴胡,白芍,陈皮,法半夏,浙贝母,海螵蛸,枳壳,党参,生白术,当归,甘草,生龙骨,生牡蛎,</b>珍珠母,<b>白花蛇舌草,醋三棱,醋莪术,半枝莲,</b>三七<b>,旋覆花,煅赭石</b></td>
      <td><b>醋三棱,醋莪术,半枝莲,半边莲,藤梨根,旋覆花,煅赭石,甘草,柴胡,白芍,赤芍,陈皮,法半夏,浙贝母,煅瓦楞子,海螵蛸,枳壳,党参,生白术,桂枝,生龙骨,生牡蛎,黄连,当归,合欢皮,合欢花,天花粉,生地黄,黄芪,防风,白花蛇舌草,川芎</b></td>
    </tr>
    <tr>
        <td>请根据脾胃病患者的症状信息进行中医处方推荐。大便不成形年;服药后症状改善不明显,现大便不成形,日次,质黏,粘马桶,进食时腹痛,腹胀减轻,排气减少,晨起恶心好转,近日腹泻未作,腹部畏寒同前,乏力减轻,纳欠佳,无食欲,睡眠可,小便正常,急躁易怒</td>
      <td><b>炙甘草</b>,干姜,白术,<b>茯苓,半夏,陈皮,</b>枳壳,泽泻,荷叶,薏苡仁,大腹皮,麦芽</td>
      <td>党参,白术,<b>茯苓</b>,甘草,砂仁,桔梗,薏苡仁,莲子,<b>扁豆,山药</b>,苍术,厚朴,<b>陈皮,半夏</b>,生姜,大枣,枳壳,吴茱萸,干姜<b>,灸甘草,当归,川芎</b>,肉桂</td>
      <td><b>马齿苋,山药,白芍,</b>北柴胡,<b>芡实,陈皮,麸炒白术,茯苓,防风,乌梅,当归,麸煨肉豆蔻,</b>麸炒芡实,<b>五味子,炙甘草,北败酱草,诃子,盐补骨脂,炒麦芽</b></td>
      <td><b>砂仁,醋延胡索,赤石脂,茯苓,法半夏,胡黄连,马齿苋,诃子,芡实,麸炒白术,北败酱草,当归,菊花,陈皮,麸神曲,川芎,山药,五味子,白芍,盐补骨脂,麸煨肉豆蔻,蝉蜕,炒麦芽,炒白扁豆,木香,炙甘草,炒鸡内金,枸杞子,炒僵蚕,乌梅,防风,黄芪</b></td>
    </tr>
    <tr>
        <td>请根据糖尿病患者的症状信息进行中医处方推荐。上肢麻木加重,皮肤瘙痒不变,舌苔白,舌苔薄,舌淡,舌暗</td>
        <td>黄芪,桂枝,白术,川芎,熟地,五味子,生姜,大枣</td>
        <td>黄芪,党参,大枣,萆薢,黄柏,茯苓,泽泻,麻黄,附子,细辛,当归,川芎,桃仁,红花,羌活,防风,藁本,细辛</td>
      <td><b>干姜,黄连,黄芩,太子参,桑叶,桑枝,天花粉,乌梅</b></td>
      <td><b>干姜,黄连,黄芩,太子参,桑叶,桑枝,天花粉,鸡血藤,夜交藤,知母,葛根,乌梅</b></td>
    </tr>
    <tr>
        <td>请根据糖尿病患者的症状信息进行中医处方推荐。怕冷,苔白,脉数,脉弦,舌红</td>
      <td>人参,白术,茯苓,<b>甘草</b>,附子,干姜</td>
      <td>人参（或党参）,白术,茯苓,炙甘草肉桂,附子（先煎）,姜半夏,泽泻,苡仁,陈皮,<b>黄连</b>,黄芩,白扁豆,山药</td>
      <td><b>黄芪,桂枝,鸡血藤,夜交藤,甘草,白芍</b></td>
      <td><b>鸡血藤,白芍,黄芪,黄连,知母,桂枝,夜交藤,甘草</b></td>
    </tr>
</table>


注：
1. 在测试ChatGPT、通义千问模型时，是从结果中将处方的药物手动提取出来，以方便模型对比。
2. 文本加粗的为正确药物（与医生一致）。


#### 模型性能对比

<table style="text-align:center; vertical-align:middle">
	<tr>
	    <th>Dataset</th>
        <th>Method</th>
	    <th>P@5</th>
	    <th>R@5</th>  
        <th>F1@5</th>
	    <th>P@10</th> 
        <th>R@10</th>
	    <th>F1@10</th>
        <th>P@20</th>
	    <th>R@20</th> 
        <th>F1@20</th>
	</tr >
	<tr >
	    <td rowspan="3">CMCC</td>
	    <td>PTM(d)</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td>
	</tr>
	<tr>
	    <td>TCMPR</td><td>0.3098</td><td>0.1314</td><td>0.1845</td><td>0.2531</td><td>0.2116</td><td>0.2305</td><td>0.1868</td><td>0.3085</td><td>0.2327</td>
	</tr>
	<tr>
        <td>TCMLLM-PR</td><td>0.2678 </td><td>0.1128 </td><td>0.1537 </td><td>0.2219 </td><td>0.1864 </td><td>0.1956 </td><td>0.1270 </td><td>0.2127 </td><td>0.1541 </td>
	</tr>
    <tr >
	    <td rowspan="3">CHP</td>
	    <td>PTM(d)</td><td>0.2044</td><td>0.1019</td><td>0.1360</td><td>0.1751</td><td>0.1784</td><td>0.1767</td><td>0.1385</td><td>0.2889</td><td>0.1872</td>
	</tr>
	<tr>
	    <td>TCMPR</td><td>0.1545</td><td>0.0719</td><td>0.0982</td><td>0.1237</td><td>0.1205</td><td>0.1221</td><td>0.1097</td><td>0.2264</td><td>0.1477</td>
	</tr>
    <tr>
      <td><b>TCMLLM-PR</b></td><td><b>0.3632 </b></td><td><b>0.2508</b> </td><td><b>0.2642</b> </td><td><b>0.2804</b> </td><td><b>0.3489</b> </td><td><b>0.2818</b> </td><td><b>0.1593</b> </td><td><b>0.3771</b> </td><td><b>0.2064</b> </td>
    </tr>
    <tr >
	    <td rowspan="3">Diabetes</td>
	    <td><b>PTM(d)</b></td><td><b>0.4835</b></td><td><b>0.2549</b></td><td><b>0.3338</b></td><td><b>0.3892</b></td><td><b>0.4132</b></td><td><b>0.4008</b></td><td><b>0.2897</b></td><td><b>0.6118</b></td><td><b>0.3932</b></td>
	</tr>
	<tr>
	    <td>TCMPR</td><td>0.4648</td><td>0.2460</td><td>0.3217</td><td>0.3788</td><td>0.4026</td><td>0.3903</td><td>0.2802</td><td>0.5935</td><td>0.3807</td>
	</tr>
    <tr>
      <td>TCMLLM-PR</td><td>0.3548 </td><td>0.1880 </td><td>0.2420 </td><td>0.2652 </td><td>0.2786 </td><td>0.2671 </td><td>0.1358 </td><td>0.2852 </td><td>0.1812 </td>
    </tr>
    <tr >
	    <td rowspan="3">Liver</td>
	    <td><b>PTM(d)</b></td><td><b>0.5753</b></td><td><b>0.1560</b></td><td><b>0.2454</b></td><td><b>0.4765</b></td><td><b>0.2554</b></td><td><b>0.3326</b></td><td><b>0.3853</b></td><td><b>0.4045</b></td><td><b>0.3947</b></td>
	</tr>
	<tr>
	    <td>TCMPR</td><td>0.5531</td><td>0.1487</td><td>0.2343</td><td>0.4536</td><td>0.2427</td><td>0.3162</td><td>0.3754</td><td>0.3946</td><td>0.3847</td>
	</tr>
    <tr>
      <td>TCMLLM-PR</td><td>0.3876 </td><td>0.1037 </td><td>0.1572 </td><td>0.3291 </td><td>0.1751 </td><td>0.2179 </td><td>0.2579 </td><td>0.2705 </td><td>0.2505 </td>
    </tr>
    <tr >
	    <td rowspan="3">Lung</td>
	    <td>PTM(d)</td><td>0.5827 </td><td>0.1700 </td><td>0.2632 </td><td>0.5086 </td><td>0.2949 </td><td>0.3733 </td><td>0.4083 </td><td>0.4726 </td><td>0.4381 </td>
	</tr>
	<tr>
	    <td><b>TCMPR</b></td><td><b>0.5890</b> </td><td><b>0.1716</b> </td><td><b>0.2657</b> </td><td><b>0.5119</b> </td><td><b>0.2967</b> </td><td><b>0.3756</b> </td><td><b>0.4114</b> </td><td><b>0.4761</b> </td><td><b>0.4414</b> </td>
	</tr>
    <tr>
      <td>TCMLLM-PR</td><td>0.3750 </td><td>0.1082 </td><td>0.1671 </td><td>0.3138 </td><td>0.1809 </td><td>0.2279 </td><td>0.2991 </td><td>0.3457 </td><td>0.3183 </td>
    </tr>
      <tr >
	    <td rowspan="3">ISGP</td>
	    <td>PTM(d)</td><td>0.3822 </td><td>0.2113 </td><td>0.2722 </td><td>0.3071 </td><td>0.3415 </td><td>0.3234 </td><td>0.2179 </td><td>0.4810 </td><td>0.2999 </td>
	</tr>
	<tr>
	    <td>TCMPR</td><td>0.4950 </td><td>0.3038 </td><td>0.3765 </td><td>0.4183 </td><td>0.4838 </td><td>0.4487 </td><td>0.2803 </td><td>0.6314 </td><td>0.3883 </td>
	</tr>
    <tr>
      <td><b>TCMLLM-PR</b></td><td><b>0.7378 </b></td><td><b>0.4356 </b></td><td><b>0.5283</b> </td><td><b>0.5786</b> </td><td><b>0.6448 </b></td><td><b>0.5914</b> </td><td><b>0.3138 </b></td><td><b>0.6808 </b></td><td><b>0.4180 </b></td>
    </tr>
    <tr >
	    <td rowspan="3">SSD</td>
	    <td>PTM(d)</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td>
	</tr>
	<tr>
	    <td>TCMPR</td><td>0.7150 </td><td>0.1562 </td><td>0.2564 </td><td>0.6286 </td><td>0.2732 </td><td>0.3809 </td><td>0.5166 </td><td>0.4453 </td><td>0.4783 </td>
	</tr>
    <tr>
      <td>TCMLLM-PR</td><td>0.5371 </td><td>0.1139 </td><td>0.1866 </td><td>0.4351 </td><td>0.1842 </td><td>0.2562 </td><td>0.3494 </td><td>0.2937 </td><td>0.3155 </td>
    </tr>
	<tr>
	    <td rowspan="3">Stroke</td>
	    <td><b>PTM(d)</b></td><td><b>0.6440</b> </td><td><b>0.2133</b> </td><td><b>0.3204</b> </td><td><b>0.5353 </b></td><td><b>0.3513 </b></td><td><b>0.4242</b> </td><td><b>0.4187</b> </td><td><b>0.5476</b> </td><td><b>0.4746</b> </td>
	</tr>
	<tr>
        <td>TCMPR</td><td>0.5783 </td><td>0.1903 </td><td>0.2863 </td><td>0.5085 </td><td>0.3335 </td><td>0.4028 </td><td>0.4084 </td><td>0.5344 </td><td>0.4630 </td>
	</tr>
	<tr>
	   <td>TCMLLM-PR</td><td>0.3528 </td><td>0.1140 </td><td>0.1714 </td><td>0.3770 </td><td>0.2444 </td><td>0.2946 </td><td>0.3090 </td><td>0.3999 </td><td>0.3463 </td>
	</tr>
<tr >
	    <td rowspan="3">Mixed</td>
	    <td>PTM(d)</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td><td>-</td>
	</tr>
	<tr>
	    <td>TCMPR</td><td>0.4921</td><td>0.1547</td><td>0.2354</td><td>0.4243</td><td>0.2626</td><td>0.3244</td><td>0.3399</td><td>0.4133</td><td>0.3731</td>
	</tr>
    <tr>
      <td>TCMLLM-PR</td><td>0.3933 </td><td>0.1300 </td><td>0.1870 </td><td>0.3243 </td><td>0.2111 </td><td>0.2437 </td><td>0.2488 </td><td>0.3033 </td><td>0.2622 </td>
    </tr>
	
</table>

注：基线模型为: 1) PTM（一种基于主题模型的处方推荐算法, [Yao et al. TKDE 2018](https://ieeexplore.ieee.org/document/8242679)）; 2) TCMPR（一种基于症状术语映射与深度学习的中医处方推荐算法, [Dong et al. BIBM 2021](https://ieeexplore.ieee.org/document/9669588)）


### 处方推荐任务交叉验证
<table style="text-align:center; vertical-align:middle">
	<tr>
	    <th>Dataset1</th>
        <th>Dataset2</th>
	    <th>P@5</th>
	    <th>R@5</th>  
        <th>F1@5</th>
	    <th>P@10</th> 
        <th>R@10</th>
	    <th>F1@10</th>
        <th>P@20</th>
	    <th>R@20</th> 
        <th>F1@20</th>
	</tr >
	<tr >
	    <td rowspan="3">CHP</td>
	    <td>Stroke</td>
        <td>0.1123 </td><td>0.0364 </td><td>0.0546 </td><td>0.0959 </td><td>0.0619 </td><td>0.0746 </td><td>0.0632 </td><td>0.0821 </td><td>0.0707 </td>
	</tr>
	<tr>
	    <td>Liver</td>
	    <td>0.1794 </td><td>0.0455 </td><td>0.0704 </td><td>0.1608 </td><td>0.0820 </td><td>0.1048 </td><td>0.0987 </td><td>0.1007 </td><td>0.0958 </td>
	</tr>
	<tr>
	    <td>SSD</td>
        <td>0.2871 </td><td>0.0596 </td><td>0.0980 </td><td>0.2175 </td><td>0.0901 </td><td>0.1262 </td><td>0.1290 </td><td>0.1068 </td><td>0.1155 </td>
	</tr>
	<tr>
	    <td rowspan="3">ISGP</td>
	    <td>Stroke</td>
        <td>0.1918 </td><td>0.0619 </td><td>0.0930 </td><td>0.1550 </td><td>0.0997 </td><td>0.1204 </td><td>0.0831 </td><td>0.1072 </td><td>0.0929 </td>
	</tr>
	<tr><td>Liver</td>
	    <td>0.2990 </td><td>0.0800 </td><td>0.1225 </td><td>0.2338 </td><td>0.1232 </td><td>0.1551 </td><td>0.1232 </td><td>0.1296 </td><td>0.1209 </td>
	</tr>
	<tr>
	    <td>SSD</td>
	    <td>0.2487 </td><td>0.0520 </td><td>0.0853 </td><td>0.1918 </td><td>0.0795 </td><td>0.1112 </td><td>0.1017 </td><td>0.0840 </td><td>0.0908 </td>
	</tr>
	
</table>
注：处方推荐任务交叉验证指在Dataset1的训练集进行大模型指令微调，使用Dataset2的测试集进行性能测试。

#### 模型训练效果
![image](https://github.com/2020MEAI/TCMLLM/assets/75461468/408bc2bd-b8dd-4800-8743-d91093f14709)




## 项目参与者
本项目由北京交通大学计算机与信息技术学院医学智能团队田昊宇、董鑫、徐宽、花睿、赵辰羲、王鸿燕、叶明蔚和胡敏杰等完成，项目负责人为杨扩和周雪忠老师。另外，感谢多家合作单位提供的医疗数据。

  

## 致谢
本项目参考了以下开源项目，在此对相关项目和研究开发人员表示感谢。
- ChatGLM-6B: https://github.com/THUDM/ChatGLM-6B
- Facebook LLaMA: https://github.com/facebookresearch/llama
- Stanford Alpaca: https://github.com/tatsu-lab/stanford_alpaca
- Huatuo: https://github.com/SCIR-HI/Huatuo-Llama-Med-Chinese

  
## 免责声明

本项目相关资源仅供学术研究之用，严禁用于商业用途。使用涉及第三方代码的部分时，请严格遵循相应的开源协议。模型生成的内容受模型计算、随机性和量化精度损失等因素影响，本项目无法对其准确性作出保证。本项目数据集绝大部分由模型生成，即使符合某些医学事实，也不能被用作实际医学诊断的依据。对于模型输出的任何内容，本项目不承担任何法律责任，亦不对因使用相关资源和输出结果而可能产生的任何损失承担责任。


## Citation

如果你使用了本项目的数据或者代码，请声明引用

	  @misc{alpaca,
	  author={Xuezhong Zhou,Kuo Yang,Haoyu Tian,Xin Dong,Kuan Xu,Rui Hua},
	  title = {TCMLLM},
	  year = {2023},
	  publisher = {GitHub},
	  journal = {GitHub repository},
	  howpublished = {\url{https://github.com/2020MEAI/TCMLLM}},
	}


