/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.sql;

import cn.ict.githubserver.domain.req.RuleDetailReq;
import java.util.HashMap;

public class RuleExecutorSqlProvider {
    public String buildGetRuleExecutorStatisticsSql(RuleDetailReq req) {
        StringBuilder sql = new StringBuilder();
        sql.append("    SELECT * FROM (\n        SELECT rule_executor.id AS id, rule_id,r.`condition`,\n               ROUND(rule_executor.`target_num` / (rule_executor.`target_num` * 3600000), 2) AS discoverEfficiency,\n               rule_executor.`duration`,\n               rule_executor.`target_num`,\n               rule_executor.`process_num`\n        FROM rule_executor\n        LEFT JOIN rule r ON rule_executor.rule_id = r.id\n");
        if (req.getRuleId() != null) {
            sql.append(" WHERE rule_executor.rule_id = #{req.ruleId} ");
        }
        sql.append(") AS res ");
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("duration", "duration");
        fieldMap.put("targetNum", "target_num");
        fieldMap.put("discoverEfficiency", "discoverEfficiency");
        fieldMap.put("processNum", "process_num");
        fieldMap.put("ruleId", "rule_id");
        if (req.getOrderBy() != null && req.getOrderBy().matches("duration|targetNum|processNum|ruleId|discoverEfficiency")) {
            String sortBy = "asc".equalsIgnoreCase(req.getSortBy()) ? "ASC" : "DESC";
            sql.append(" ORDER BY ").append((String)fieldMap.get(req.getOrderBy())).append(" ").append(sortBy);
        } else {
            sql.append(" ORDER BY discoverEfficiency DESC");
        }
        return sql.toString();
    }
}

