/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.service.impl;

import cn.ict.githubserver.covert.SuspectedToolCovert;
import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.AddToolReq;
import cn.ict.githubserver.domain.req.QueryToolReq;
import cn.ict.githubserver.domain.resp.SuspectedToolResp;
import cn.ict.githubserver.entity.SuspectedTool;
import cn.ict.githubserver.mapper.SuspectedToolMapper;
import cn.ict.githubserver.service.SuspectedToolService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SuspectedToolServiceImpl
implements SuspectedToolService {
    private static final Logger log = LoggerFactory.getLogger(SuspectedToolServiceImpl.class);
    @Resource
    private SuspectedToolMapper suspectedToolMapper;
    @Resource
    private SuspectedToolCovert suspectedToolCovert;

    public PageDTO<SuspectedToolResp> pageList(QueryToolReq req) {
        SuspectedTool dbParam = this.suspectedToolCovert.toDbParam(req);
        IPage iPage = this.suspectedToolMapper.pageList(dbParam, (IPage)new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue()));
        return new PageDTO(Long.valueOf(iPage.getTotal()), this.suspectedToolCovert.toResp(iPage.getRecords()));
    }

    public SuspectedToolResp findInfo(Long id) {
        return this.suspectedToolCovert.toResp((SuspectedTool)this.suspectedToolMapper.selectById((Serializable)id));
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(AddToolReq req) {
        SuspectedTool stTool = this.suspectedToolCovert.addReqToDbParam(req);
        this.suspectedToolMapper.insert((Object)stTool);
    }

    public void delete(List<Long> idList) {
        this.suspectedToolMapper.deleteBatchIds(idList);
    }

    public void exportExcel(ServletOutputStream outputStream, QueryToolReq req) {
        Class<SuspectedToolResp> exportClass = SuspectedToolResp.class;
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream, exportClass).autoCloseStream(Boolean.valueOf(false)).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((String)"\u7591\u4f3c\u5de5\u5177\u5bfc\u51fa").build();
        int pageSize = 500;
        int pageNum = 1;
        while (true) {
            req.setPageNum(Integer.valueOf(pageNum));
            req.setPageSize(Integer.valueOf(pageSize));
            List records = this.pageList(req).getRecords();
            if (CollectionUtils.isEmpty((Collection)records)) break;
            excelWriter.write((Collection)records, writeSheet);
            if (records.size() < pageSize) break;
            ++pageNum;
        }
        excelWriter.finish();
    }

    public void update(AddToolReq req) {
        this.suspectedToolMapper.updateById((Object)this.suspectedToolCovert.addReqToDbParam(req));
    }
}

