/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.service.impl;

import cn.ict.githubserver.covert.SampleUrlCovert;
import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.QuerySampleReq;
import cn.ict.githubserver.domain.resp.SampleUrlResp;
import cn.ict.githubserver.entity.SampleUrl;
import cn.ict.githubserver.mapper.SampleUrlMapper;
import cn.ict.githubserver.service.SampleUrlService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SampleUrlServiceImpl
implements SampleUrlService {
    private static final Logger log = LoggerFactory.getLogger(SampleUrlServiceImpl.class);
    @Resource
    private SampleUrlMapper sampleUrlMapper;
    @Resource
    private SampleUrlCovert sampleUrlCovert;

    public PageDTO<SampleUrlResp> pageList(QuerySampleReq req) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(CollectionUtils.isNotEmpty((Collection)req.getIdList()), SampleUrl::getId, (Collection)req.getIdList())).apply(StringUtils.isNotBlank((CharSequence)req.getSourceProject()), "full_name MATCH_PHRASE {0}", new Object[]{req.getSourceProject()})).apply(StringUtils.isNotBlank((CharSequence)req.getUrl()), "url MATCH_PHRASE {0}", new Object[]{req.getUrl()})).apply(StringUtils.isNotBlank((CharSequence)req.getSourceUser()), "user_login MATCH_PHRASE {0}", new Object[]{req.getSourceUser()})).in(CollectionUtils.isNotEmpty((Collection)req.getPushStatusList()), SampleUrl::getSs, (Collection)req.getPushStatusList())).gt(Objects.nonNull(req.getFtStartTime()), SampleUrl::getFt, (Object)req.getFtStartTime())).lt(Objects.nonNull(req.getFtEndTime()), SampleUrl::getFt, (Object)req.getFtEndTime())).gt(Objects.nonNull(req.getPushStartTime()), SampleUrl::getSt, (Object)req.getPushStartTime())).lt(Objects.nonNull(req.getPushEndTime()), SampleUrl::getSt, (Object)req.getPushEndTime())).orderBy("ft".equals(req.getOrderBy()), "asc".equals(req.getSortBy()), SampleUrl::getFt)).orderBy("st".equals(req.getOrderBy()), "asc".equals(req.getSortBy()), SampleUrl::getSt);
        IPage page = this.sampleUrlMapper.selectPage((IPage)new Page((long)req.getPageNum().intValue(), (long)req.getPageSize().intValue()), (Wrapper)queryWrapper);
        return new PageDTO(Long.valueOf(page.getTotal()), this.sampleUrlCovert.toResp(page.getRecords()));
    }

    public void exportExcel(ServletOutputStream outputStream, QuerySampleReq req) {
        Class<SampleUrlResp> exportClass = SampleUrlResp.class;
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream, exportClass).autoCloseStream(Boolean.valueOf(false)).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((String)"\u6837\u672c\u94fe\u63a5\u5bfc\u51fa").build();
        int pageSize = 500;
        int pageNum = 1;
        while (true) {
            req.setPageNum(Integer.valueOf(pageNum));
            req.setPageSize(Integer.valueOf(pageSize));
            List records = this.pageList(req).getRecords();
            if (CollectionUtils.isEmpty((Collection)records)) break;
            excelWriter.write((Collection)records, writeSheet);
            if (records.size() < pageSize) break;
            ++pageNum;
        }
        excelWriter.finish();
    }

    public SampleUrlResp findInfo(Long id) {
        return this.sampleUrlCovert.toResp((SampleUrl)this.sampleUrlMapper.selectById((Serializable)id));
    }
}

