/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.service.impl;

import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.PageReq;
import cn.ict.githubserver.domain.req.RuleAddReq;
import cn.ict.githubserver.domain.req.RuleDetailReq;
import cn.ict.githubserver.domain.req.RuleReq;
import cn.ict.githubserver.domain.req.RuleStatisticsReq;
import cn.ict.githubserver.domain.resp.RuleExecutorResp;
import cn.ict.githubserver.domain.resp.RuleResp;
import cn.ict.githubserver.entity.Rule;
import cn.ict.githubserver.mapper.RuleMapper;
import cn.ict.githubserver.service.RuleExecutorService;
import cn.ict.githubserver.service.RuleService;
import cn.ict.githubserver.util.InstantConverter;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.servlet.ServletOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RuleServiceImpl
extends ServiceImpl<RuleMapper, Rule>
implements RuleService {
    private static final Logger log = LoggerFactory.getLogger(RuleServiceImpl.class);
    @Autowired
    private RuleMapper ruleMapper;
    @Autowired
    private RuleExecutorService ruleExecutorService;

    private LambdaQueryWrapper<Rule> queryWrapper(RuleReq ruleReq) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ruleReq.getId() != null) {
            queryWrapper.eq(Rule::getId, (Object)ruleReq.getId());
        }
        if (ruleReq.getActive() != null) {
            queryWrapper.eq(Rule::isActive, (Object)ruleReq.getActive());
        }
        if (ruleReq.getDelete() != null) {
            queryWrapper.eq(Rule::isDelete, (Object)ruleReq.getDelete());
        }
        if (CollectionUtils.isNotEmpty((Collection)ruleReq.getIds())) {
            queryWrapper.in(Rule::getId, (Collection)ruleReq.getIds());
        }
        if (Objects.nonNull(ruleReq.getCreateTimeStart())) {
            queryWrapper.ge(Rule::getCreateTime, (Object)ruleReq.getCreateTimeStart());
        }
        if (Objects.nonNull(ruleReq.getCreateTimeEnd())) {
            queryWrapper.le(Rule::getCreateTime, (Object)ruleReq.getCreateTimeEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)ruleReq.getCondition())) {
            queryWrapper.like(Rule::getCondition, (Object)ruleReq.getCondition());
        }
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("id", Rule::getId);
        fieldMap.put("interval", Rule::getInterval);
        fieldMap.put("scheduleTime", Rule::getScheduleTime);
        fieldMap.put("createTime", Rule::getCreateTime);
        if (StringUtils.isNotEmpty((CharSequence)ruleReq.getOrderBy())) {
            if ("desc".equals(ruleReq.getSortBy())) {
                queryWrapper.orderByDesc((Object)((SFunction)fieldMap.get(ruleReq.getOrderBy())));
            } else {
                queryWrapper.orderByAsc((Object)((SFunction)fieldMap.get(ruleReq.getOrderBy())));
            }
        }
        return queryWrapper;
    }

    private RuleResp toDTO(Rule rule) {
        RuleResp ruleResp = new RuleResp();
        BeanUtils.copyProperties((Object)rule, (Object)ruleResp);
        return ruleResp;
    }

    @Transactional(readOnly=true)
    public List<Rule> list(RuleReq ruleReq) {
        LambdaQueryWrapper queryWrapper = this.queryWrapper(ruleReq);
        return this.ruleMapper.selectList((Wrapper)queryWrapper);
    }

    @Transactional(readOnly=true)
    public PageDTO<RuleResp> list(RuleReq ruleReq, PageReq pageReq) {
        LambdaQueryWrapper queryWrapper = this.queryWrapper(ruleReq);
        Page page = new Page((long)pageReq.getPageNum().intValue(), (long)pageReq.getPageSize().intValue());
        Page rulePage = (Page)this.ruleMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List respList = rulePage.getRecords().stream().map(rule -> {
            RuleResp ruleResp = new RuleResp();
            BeanUtils.copyProperties((Object)rule, (Object)ruleResp);
            return ruleResp;
        }).collect(Collectors.toList());
        return new PageDTO(Long.valueOf(rulePage.getTotal()), respList);
    }

    @Transactional(readOnly=true)
    public List<Rule> findActiveRules() {
        RuleReq ruleReq = new RuleReq();
        ruleReq.setActive(Boolean.valueOf(true));
        ruleReq.setDelete(Boolean.valueOf(false));
        return this.list(ruleReq);
    }

    public Rule updateLastScheduleTime(Rule rule) {
        log.debug("Request to update last schedule time, rule={}", (Object)rule);
        rule.setScheduleTime(Instant.now());
        this.updateById((Object)rule);
        return rule;
    }

    public Optional<Instant> getScheduleTime(Long id) {
        log.debug("Request to get schedule time by id={}", (Object)id);
        return this.getOptById((Serializable)id).map(Rule::getScheduleTime);
    }

    @Transactional(readOnly=true)
    public PageDTO<RuleResp> pageList(RuleReq ruleReq) {
        LambdaQueryWrapper lambdaQueryWrapper = this.queryWrapper(ruleReq);
        Page page = new Page((long)ruleReq.getPageNum().intValue(), (long)ruleReq.getPageSize().intValue());
        Page rulePage = (Page)this.ruleMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
        List respList = rulePage.getRecords().stream().map(rule -> {
            RuleResp resp = new RuleResp();
            BeanUtils.copyProperties((Object)rule, (Object)resp);
            return resp;
        }).collect(Collectors.toList());
        return new PageDTO(Long.valueOf(rulePage.getTotal()), respList);
    }

    public void exportExcel(ServletOutputStream outputStream, RuleReq ruleReq) {
        LambdaQueryWrapper lambdaQueryWrapper;
        Page page;
        Page iPage;
        List records;
        Class<RuleResp> exportClass = RuleResp.class;
        ExcelWriter excelWriter = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)outputStream, exportClass).autoCloseStream(Boolean.valueOf(false)).registerConverter((Converter)new InstantConverter())).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((String)"\u9879\u76ee\u5bfc\u51fa").build();
        int pageSize = 500;
        int pageNum = 1;
        while (!CollectionUtils.isEmpty((Collection)(records = (iPage = (Page)this.page((IPage)(page = new Page((long)pageNum, (long)pageSize)), (Wrapper)(lambdaQueryWrapper = this.queryWrapper(ruleReq)))).getRecords()))) {
            List exportList = records.stream().map(project -> {
                RuleResp resp = new RuleResp();
                BeanUtils.copyProperties((Object)project, (Object)resp);
                return resp;
            }).collect(Collectors.toList());
            excelWriter.write(exportList, writeSheet);
            if (records.size() < pageSize) break;
            ++pageNum;
        }
        excelWriter.finish();
    }

    public Integer addRule(RuleAddReq ruleAddReq) {
        Rule rule = new Rule();
        BeanUtils.copyProperties((Object)ruleAddReq, (Object)rule);
        int num = this.ruleMapper.insert((Object)rule);
        return num;
    }

    public Integer updateRule(RuleAddReq ruleAddReq) {
        Rule rule = new Rule();
        BeanUtils.copyProperties((Object)ruleAddReq, (Object)rule);
        int num = this.ruleMapper.updateById((Object)rule);
        return num;
    }

    public Integer delRule(Long id) {
        Rule rule = new Rule();
        rule.setId(id);
        rule.setDelete(true);
        int num = this.ruleMapper.updateById((Object)rule);
        return num;
    }

    public Boolean delRules(List<Long> ids) {
        List rules = ids.stream().map(id -> {
            Rule rule = new Rule();
            rule.setId(id);
            rule.setDelete(true);
            return rule;
        }).collect(Collectors.toList());
        Boolean flag = this.updateBatchById(rules);
        return flag;
    }

    public Integer stopRule(Long id) {
        Rule rule = new Rule();
        rule.setId(id);
        rule.setActive(false);
        Integer num = this.ruleMapper.updateById((Object)rule);
        return num;
    }

    public PageDTO<RuleExecutorResp> ruleDetail(RuleDetailReq ruleDetailReq) {
        PageDTO respPageDTO = this.ruleExecutorService.ruleDetail(ruleDetailReq);
        return respPageDTO;
    }

    public List<String> groupByCondition() {
        List remarks = this.ruleMapper.distinctCondition();
        return remarks;
    }

    public List<RuleExecutorResp> ruleStatistics(RuleStatisticsReq ruleStatisticsReq) {
        if (StringUtils.isNotEmpty((CharSequence)ruleStatisticsReq.getOrderBy())) {
            ruleStatisticsReq.setOrderBy("discoverEfficiency");
            ruleStatisticsReq.setSortBy("desc");
        }
        List rules = this.ruleMapper.ruleStatistics(ruleStatisticsReq.getOrderBy(), ruleStatisticsReq.getSortBy());
        return rules;
    }

    public RuleResp selectById(Long id) {
        Rule rule = (Rule)this.ruleMapper.selectById((Serializable)id);
        RuleResp resp = new RuleResp();
        BeanUtils.copyProperties((Object)rule, (Object)resp);
        return resp;
    }

    public List<RuleResp> selectByIds(List<Long> ids) {
        List ruleList = this.ruleMapper.selectBatchIds(ids);
        List<RuleResp> respList = ruleList.stream().map(rule -> {
            RuleResp resp = new RuleResp();
            BeanUtils.copyProperties((Object)rule, (Object)resp);
            return resp;
        }).collect(Collectors.toList());
        return respList;
    }
}

