/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.service.impl;

import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.PublicProjectReq;
import cn.ict.githubserver.domain.resp.PublicProjectResp;
import cn.ict.githubserver.entity.PublicProject;
import cn.ict.githubserver.mapper.PublicProjectMapper;
import cn.ict.githubserver.service.PublicProjectService;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.servlet.ServletOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional
public class PublicProjectServiceImpl
extends ServiceImpl<PublicProjectMapper, PublicProject>
implements PublicProjectService {
    @Autowired
    private PublicProjectMapper publicProjectMapper;

    public List<PublicProject> list(PublicProjectReq publicProjectReq) {
        LambdaQueryWrapper queryWrapper = PublicProjectServiceImpl.getPublicProjectLambdaQueryWrapper((PublicProjectReq)publicProjectReq);
        return this.publicProjectMapper.selectList((Wrapper)queryWrapper);
    }

    public PageDTO<PublicProjectResp> page(PublicProjectReq publicProjectReq) {
        LambdaQueryWrapper queryWrapper = PublicProjectServiceImpl.getPublicProjectLambdaQueryWrapper((PublicProjectReq)publicProjectReq);
        Page page = new Page((long)publicProjectReq.getPageNum().intValue(), (long)publicProjectReq.getPageSize().intValue());
        Page projectPage = (Page)this.publicProjectMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List respList = projectPage.getRecords().stream().map(project -> {
            PublicProjectResp resp = new PublicProjectResp();
            BeanUtils.copyProperties((Object)project, (Object)resp);
            return resp;
        }).collect(Collectors.toList());
        return new PageDTO(Long.valueOf(projectPage.getTotal()), respList);
    }

    private static LambdaQueryWrapper<PublicProject> getPublicProjectLambdaQueryWrapper(PublicProjectReq publicProjectReq) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (CollectionUtils.isNotEmpty((Collection)publicProjectReq.getIds())) {
            queryWrapper.in(PublicProject::getId, (Collection)publicProjectReq.getIds());
        }
        if (StringUtils.isNotEmpty((CharSequence)publicProjectReq.getFullName())) {
            queryWrapper.apply("full_name MATCH_PHRASE {0}", new Object[]{publicProjectReq.getFullName()});
        }
        if (StringUtils.isNotEmpty((CharSequence)publicProjectReq.getDesc())) {
            queryWrapper.apply("desc MATCH_PHRASE {0}", new Object[]{publicProjectReq.getDesc()});
        }
        if (StringUtils.isNotEmpty((CharSequence)publicProjectReq.getUserId())) {
            queryWrapper.eq(PublicProject::getUserId, (Object)publicProjectReq.getUserId());
        }
        if (StringUtils.isNotEmpty((CharSequence)publicProjectReq.getRelease())) {
            queryWrapper.eq(PublicProject::getRelease, (Object)publicProjectReq.getRelease());
        }
        if (Objects.nonNull(publicProjectReq.getGtStart())) {
            queryWrapper.ge(PublicProject::getGt, (Object)publicProjectReq.getGtStart());
        }
        if (Objects.nonNull(publicProjectReq.getGtEnd())) {
            queryWrapper.le(PublicProject::getGt, (Object)publicProjectReq.getGtEnd());
        }
        if (Objects.nonNull(publicProjectReq.getToolId())) {
            queryWrapper.apply("array_contains(tools, {0})", new Object[]{publicProjectReq.getToolId()});
        }
        if (Objects.nonNull(publicProjectReq.getSampleId())) {
            queryWrapper.apply("array_contains(samples, {0})", new Object[]{publicProjectReq.getSampleId()});
        }
        if (Objects.nonNull(publicProjectReq.getMirrorSiteId())) {
            queryWrapper.apply("array_contains(sites, {0})", new Object[]{publicProjectReq.getMirrorSiteId()});
        }
        if (Objects.nonNull(publicProjectReq.getResourceId())) {
            queryWrapper.apply("array_contains(resources, {0})", new Object[]{publicProjectReq.getResourceId()});
        }
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("fullName", PublicProject::getFullName);
        fieldMap.put("gt", PublicProject::getGt);
        if (StringUtils.isNotEmpty((CharSequence)publicProjectReq.getOrderBy())) {
            if ("desc".equals(publicProjectReq.getSortBy())) {
                queryWrapper.orderByDesc((Object)((SFunction)fieldMap.get(publicProjectReq.getOrderBy())));
            } else {
                queryWrapper.orderByAsc((Object)((SFunction)fieldMap.get(publicProjectReq.getOrderBy())));
            }
        } else {
            queryWrapper.orderByDesc(PublicProject::getFullName);
        }
        return queryWrapper;
    }

    @Transactional(readOnly=true)
    public List<PublicProject> getByIds(long start, long end) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.le(PublicProject::getId, (Object)end);
        queryWrapper.ge(PublicProject::getId, (Object)start);
        return this.publicProjectMapper.selectList((Wrapper)queryWrapper);
    }

    @Transactional(readOnly=true)
    public PublicProject getMaxProjectId() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.orderByDesc(PublicProject::getId)).last("LIMIT 1");
        return (PublicProject)this.publicProjectMapper.selectOne((Wrapper)wrapper);
    }

    @Transactional(readOnly=true)
    public PublicProject getMinProjectId() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.orderByAsc(PublicProject::getId)).last("LIMIT 1");
        return (PublicProject)this.publicProjectMapper.selectOne((Wrapper)wrapper);
    }

    public void exportExcel(ServletOutputStream outputStream, PublicProjectReq publicProjectReq) {
        LambdaQueryWrapper queryWrapper;
        Page page;
        IPage iPage;
        List records;
        Class<PublicProjectResp> exportClass = PublicProjectResp.class;
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream, exportClass).autoCloseStream(Boolean.valueOf(false)).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((String)"\u9879\u76ee\u5bfc\u51fa").build();
        int pageSize = 500;
        int pageNum = 1;
        while (!CollectionUtils.isEmpty((Collection)(records = (iPage = this.page((IPage)(page = new Page((long)pageNum, (long)pageSize)), (Wrapper)(queryWrapper = PublicProjectServiceImpl.getPublicProjectLambdaQueryWrapper((PublicProjectReq)publicProjectReq)))).getRecords()))) {
            List exportList = records.stream().map(record -> {
                PublicProjectResp resp = new PublicProjectResp();
                BeanUtils.copyProperties((Object)record, (Object)resp);
                return resp;
            }).collect(Collectors.toList());
            excelWriter.write(exportList, writeSheet);
            if (records.size() < pageSize) break;
            ++pageNum;
        }
        excelWriter.finish();
    }
}

