/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.service.impl;

import cn.ict.githubserver.domain.req.ProjectRuleReq;
import cn.ict.githubserver.entity.ProjectRule;
import cn.ict.githubserver.mapper.ProjectRuleMapper;
import cn.ict.githubserver.service.ProjectRuleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class ProjectRuleServiceImpl
extends ServiceImpl<ProjectRuleMapper, ProjectRule>
implements ProjectRuleService {
    private static final Logger log = LoggerFactory.getLogger(ProjectRuleServiceImpl.class);
    @Autowired
    private ProjectRuleMapper projectRuleMapper;

    private Wrapper<ProjectRule> queryCondition(ProjectRuleReq projectRuleReq) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(ProjectRule.class);
        if (projectRuleReq.getProjectId() != null) {
            queryWrapper.eq(ProjectRule::getProjectId, (Object)projectRuleReq.getProjectId());
        }
        if (projectRuleReq.getRuleId() != null) {
            queryWrapper.eq(ProjectRule::getRuleId, (Object)projectRuleReq.getRuleId());
        }
        if (!CollectionUtils.isEmpty((Collection)projectRuleReq.getProjectIds())) {
            queryWrapper.in(ProjectRule::getProjectId, (Collection)projectRuleReq.getProjectIds());
        }
        return queryWrapper;
    }

    public List<ProjectRule> list(ProjectRuleReq projectRuleReq) {
        Wrapper query = this.queryCondition(projectRuleReq);
        return this.projectRuleMapper.selectList(query);
    }

    public void updateAll(Long ruleId, List<Long> matchedProjectIds) {
        log.debug("Update or Insert ruleId and target projectIds");
        ProjectRuleReq projectRuleReq = new ProjectRuleReq();
        projectRuleReq.setProjectIds(matchedProjectIds);
        projectRuleReq.setRuleId(ruleId);
        List inDbProjectRules = this.list(this.queryCondition(projectRuleReq));
        HashSet inDBProjectIds = CollectionUtils.isEmpty((Collection)inDbProjectRules) ? new HashSet() : inDbProjectRules.stream().map(pr -> pr.getProjectId()).collect(Collectors.toSet());
        List<ProjectRule> toSavProjectRules = matchedProjectIds.stream().filter(pid -> !inDBProjectIds.contains(pid)).map(pid -> new ProjectRule(pid, ruleId, LocalDateTime.now())).toList();
        this.saveBatch(toSavProjectRules);
    }
}

