/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.service.impl;

import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.ImportantProjectReleaseReq;
import cn.ict.githubserver.domain.req.ImportantProjectReq;
import cn.ict.githubserver.domain.req.ProjectRuleReq;
import cn.ict.githubserver.domain.req.PublicProjectReq;
import cn.ict.githubserver.domain.resp.ImportantProjectProfileResp;
import cn.ict.githubserver.domain.resp.ImportantProjectResp;
import cn.ict.githubserver.domain.resp.ImportantProjectTypeCountResp;
import cn.ict.githubserver.entity.ImportantProject;
import cn.ict.githubserver.entity.ImportantProjectCrawlInfo;
import cn.ict.githubserver.entity.ImportantProjectRelease;
import cn.ict.githubserver.entity.MirrorSite;
import cn.ict.githubserver.entity.ProjectRule;
import cn.ict.githubserver.entity.ResourceUrl;
import cn.ict.githubserver.mapper.ImportantProjectMapper;
import cn.ict.githubserver.service.ImportantProjectReleaseService;
import cn.ict.githubserver.service.ImportantProjectService;
import cn.ict.githubserver.service.MirrorSiteService;
import cn.ict.githubserver.service.ProjectRuleService;
import cn.ict.githubserver.service.PublicProjectService;
import cn.ict.githubserver.service.ResourceUrlService;
import cn.ict.githubserver.service.impl.ImportantProjectCrawlServiceImpl;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional
public class ImportantProjectServiceImpl
extends ServiceImpl<ImportantProjectMapper, ImportantProject>
implements ImportantProjectService {
    private static final Logger log = LoggerFactory.getLogger(ImportantProjectServiceImpl.class);
    @Autowired
    private ImportantProjectMapper importantProjectMapper;
    @Autowired
    private PublicProjectService publicProjectService;
    @Autowired
    private ProjectRuleService projectRuleService;
    @Autowired
    private ImportantProjectCrawlServiceImpl importantProjectCrawlService;
    @Autowired
    private ImportantProjectReleaseService importantProjectReleaseService;
    @Resource
    private MirrorSiteService mirrorSiteService;
    @Resource
    private ResourceUrlService resourceUrlService;

    @Transactional(readOnly=true)
    public PageDTO<ImportantProjectResp> list(ImportantProjectReq importantProjectReq) {
        Page projectPage = this.getImportantProjectPage(importantProjectReq);
        List ids = projectPage.getRecords().stream().map(ImportantProject::getId).collect(Collectors.toList());
        List respList = projectPage.getRecords().stream().map(project -> {
            ImportantProjectResp resp = new ImportantProjectResp();
            BeanUtils.copyProperties((Object)project, (Object)resp);
            if (CollectionUtils.isNotEmpty((Collection)project.getTools())) {
                resp.setToolSize(Long.valueOf(project.getTools().size()));
            }
            if (CollectionUtils.isNotEmpty((Collection)project.getSamples())) {
                resp.setSampleSize(Long.valueOf(project.getSamples().size()));
            }
            if (CollectionUtils.isNotEmpty((Collection)project.getResources())) {
                resp.setResourceSize(Long.valueOf(project.getResources().size()));
            }
            if (CollectionUtils.isNotEmpty((Collection)project.getSites())) {
                resp.setSiteSize(Long.valueOf(project.getSites().size()));
            }
            if (CollectionUtils.isNotEmpty((Collection)project.getRules())) {
                resp.setRuleSize(Long.valueOf(project.getRules().size()));
            }
            resp.setGt(project.getGat());
            return resp;
        }).collect(Collectors.toList());
        return new PageDTO(Long.valueOf(projectPage.getTotal()), respList);
    }

    public List<ImportantProject> getImportantProjects(ImportantProjectReq importantProjectReq) {
        QueryWrapper queryWrapper = ImportantProjectServiceImpl.geImportantProjectQueryWrapper((ImportantProjectReq)importantProjectReq);
        return this.importantProjectMapper.selectList((Wrapper)queryWrapper);
    }

    private Page<ImportantProject> getImportantProjectPage(ImportantProjectReq importantProjectReq) {
        QueryWrapper queryWrapper = ImportantProjectServiceImpl.geImportantProjectQueryWrapper((ImportantProjectReq)importantProjectReq);
        Page page = new Page((long)importantProjectReq.getPageNum().intValue(), (long)importantProjectReq.getPageSize().intValue());
        Page projectPage = (Page)this.importantProjectMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return projectPage;
    }

    private static QueryWrapper<ImportantProject> geImportantProjectQueryWrapper(ImportantProjectReq importantProjectReq) {
        QueryWrapper queryWrapper = ImportantProjectServiceImpl.getGeneralImportantProjectQueryWrapper((ImportantProjectReq)importantProjectReq);
        String orderByField = importantProjectReq.getOrderBy();
        String sortBy = importantProjectReq.getSortBy();
        Set<String> arrayFields = Set.of("tools", "samples", "resources", "sites", "rules");
        if (Objects.nonNull(orderByField) && arrayFields.contains(orderByField)) {
            ImportantProjectServiceImpl.addArraySizeOrder((QueryWrapper)queryWrapper, (String)orderByField, (String)sortBy);
        }
        return queryWrapper;
    }

    private static void addArraySizeOrder(QueryWrapper<ImportantProject> queryWrapper, String fieldName, String sortDirection) {
        String orderExpression = String.format("ARRAY_SIZE(%s)", fieldName);
        if ("desc".equalsIgnoreCase(sortDirection)) {
            queryWrapper.orderByDesc(true, (Object)orderExpression);
        } else {
            queryWrapper.orderByAsc(true, (Object)orderExpression);
        }
    }

    private static QueryWrapper<ImportantProject> getGeneralImportantProjectQueryWrapper(ImportantProjectReq importantProject) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty((Collection)importantProject.getIds())) {
            queryWrapper.in((Object)"id", (Collection)importantProject.getIds());
        }
        if (Objects.nonNull(importantProject.getId())) {
            queryWrapper.eq((Object)"id", (Object)importantProject.getId());
        }
        if (Objects.nonNull(importantProject.getUserId())) {
            queryWrapper.eq((Object)"user_id", (Object)importantProject.getUserId());
        }
        if (StringUtils.isNotEmpty((CharSequence)importantProject.getFullName())) {
            queryWrapper.like((Object)"full_name", (Object)importantProject.getFullName());
        }
        if (StringUtils.isNotEmpty((CharSequence)importantProject.getRelease())) {
            queryWrapper.eq((Object)"release", (Object)importantProject.getRelease());
        }
        if (Objects.nonNull(importantProject.getGtStart())) {
            queryWrapper.ge((Object)"gt", (Object)importantProject.getGtStart());
        }
        if (Objects.nonNull(importantProject.getGtEnd())) {
            queryWrapper.le((Object)"gt", (Object)importantProject.getGtEnd());
        }
        if (Objects.nonNull(importantProject.getToolId())) {
            queryWrapper.apply("array_contains(tools, {0})", new Object[]{importantProject.getToolId()});
        }
        if (Objects.nonNull(importantProject.getSampleId())) {
            queryWrapper.apply("array_contains(samples, {0})", new Object[]{importantProject.getSampleId()});
        }
        if (Objects.nonNull(importantProject.getMirrorSiteId())) {
            queryWrapper.apply("array_contains(sites, {0})", new Object[]{importantProject.getMirrorSiteId()});
        }
        if (Objects.nonNull(importantProject.getResourceId())) {
            queryWrapper.apply("array_contains(resources, {0})", new Object[]{importantProject.getResourceId()});
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("fullName", "full_name");
        fieldMap.put("gt", "gt");
        if (Objects.nonNull(importantProject.getOrderBy()) && fieldMap.containsKey(importantProject.getOrderBy())) {
            if (StringUtils.isNotEmpty((CharSequence)importantProject.getSortBy())) {
                if ("desc".equals(importantProject.getSortBy())) {
                    queryWrapper.orderByDesc((Object)((String)fieldMap.get(importantProject.getOrderBy())));
                } else {
                    queryWrapper.orderByAsc((Object)((String)fieldMap.get(importantProject.getOrderBy())));
                }
            }
        } else {
            queryWrapper.orderByDesc((Object)"gt");
        }
        return queryWrapper;
    }

    @Transactional(readOnly=true)
    public void exportExcel(ServletOutputStream outputStream, ImportantProjectReq importantProjectReq) {
        QueryWrapper queryWrapper;
        Page page;
        Page iPage;
        List records;
        Class<ImportantProjectResp> exportClass = ImportantProjectResp.class;
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream, exportClass).autoCloseStream(Boolean.valueOf(false)).build();
        WriteSheet writeSheet = EasyExcel.writerSheet((String)"\u9879\u76ee\u5bfc\u51fa").build();
        int pageSize = 500;
        int pageNum = 1;
        while (!CollectionUtils.isEmpty((Collection)(records = (iPage = (Page)this.page((IPage)(page = new Page((long)pageNum, (long)pageSize)), (Wrapper)(queryWrapper = ImportantProjectServiceImpl.geImportantProjectQueryWrapper((ImportantProjectReq)importantProjectReq)))).getRecords()))) {
            List exportList = records.stream().map(project -> {
                ImportantProjectResp resp = new ImportantProjectResp();
                BeanUtils.copyProperties((Object)project, (Object)resp);
                if (CollectionUtils.isNotEmpty((Collection)project.getTools())) {
                    resp.setToolSize(Long.valueOf(project.getTools().size()));
                }
                if (CollectionUtils.isNotEmpty((Collection)project.getSamples())) {
                    resp.setSampleSize(Long.valueOf(project.getSamples().size()));
                }
                if (CollectionUtils.isNotEmpty((Collection)project.getResources())) {
                    resp.setResourceSize(Long.valueOf(project.getResources().size()));
                }
                if (CollectionUtils.isNotEmpty((Collection)project.getSites())) {
                    resp.setSiteSize(Long.valueOf(project.getSites().size()));
                }
                if (CollectionUtils.isNotEmpty((Collection)project.getRules())) {
                    resp.setRuleSize(Long.valueOf(project.getRules().size()));
                }
                return resp;
            }).collect(Collectors.toList());
            excelWriter.write(exportList, writeSheet);
            if (records.size() < pageSize) break;
            ++pageNum;
        }
        excelWriter.finish();
    }

    public void newImportantProjects(Long ruleId, List<Long> matchedProjectIds) {
        log.debug("find new important projects: rule={}, projects={}", (Object)ruleId, matchedProjectIds);
        if (CollectionUtils.isEmpty(matchedProjectIds)) {
            return;
        }
        ImportantProjectReq req = new ImportantProjectReq();
        req.setIds(matchedProjectIds);
        List importantProjectsInDB = this.getImportantProjects(req);
        Set importantProjectIdsInDB = importantProjectsInDB.stream().map(ImportantProject::getId).collect(Collectors.toSet());
        Set newMatchedProjectIds = matchedProjectIds.stream().filter(pid -> !importantProjectIdsInDB.contains(pid)).collect(Collectors.toSet());
        PublicProjectReq publicProjectReq = new PublicProjectReq();
        publicProjectReq.setIds(matchedProjectIds);
        List projects = this.publicProjectService.list(publicProjectReq);
        if (CollectionUtils.isEmpty((Collection)projects)) {
            return;
        }
        ProjectRuleReq projectRuleReq = new ProjectRuleReq();
        projectRuleReq.setProjectIds(matchedProjectIds);
        List projectRules = this.projectRuleService.list(projectRuleReq);
        if (CollectionUtils.isEmpty((Collection)projectRules)) {
            return;
        }
        HashMap<Long, List> projectRuleMap = new HashMap<Long, List>();
        for (ProjectRule projectRule : projectRules) {
            projectRuleMap.computeIfAbsent(projectRule.getProjectId(), k -> new ArrayList()).add(projectRule.getRuleId());
        }
        this.appendRules(importantProjectsInDB, ruleId);
        List<ImportantProject> newImportantProjects = projects.stream().filter(p -> newMatchedProjectIds.contains(p.getId())).map(p -> {
            ImportantProject importantProject = new ImportantProject();
            importantProject.setId(p.getId());
            importantProject.setName(p.getName());
            importantProject.setFullName(p.getFullName());
            importantProject.setUrl(p.getUrl());
            importantProject.setDesc(p.getDesc());
            importantProject.setUserId(p.getUserId());
            importantProject.setUserLogin(p.getUserLogin());
            importantProject.setRelease(p.getRelease());
            importantProject.setIt(p.getIt());
            importantProject.setGat(p.getGt());
            importantProject.setRules((List)projectRuleMap.get(p.getId()));
            return importantProject;
        }).toList();
        this.saveBatch(newImportantProjects);
        List<ImportantProjectCrawlInfo> importantProjectCrawlInfos = projects.stream().filter(project -> newMatchedProjectIds.contains(project.getId())).map(p -> {
            ImportantProjectCrawlInfo importantProjectCrawlInfo = new ImportantProjectCrawlInfo();
            importantProjectCrawlInfo.setName(p.getName());
            importantProjectCrawlInfo.setFullName(p.getFullName());
            importantProjectCrawlInfo.setUrl(p.getUrl());
            importantProjectCrawlInfo.setProjectId(p.getId());
            importantProjectCrawlInfo.setTaskTime(LocalDateTime.now());
            return importantProjectCrawlInfo;
        }).toList();
        this.importantProjectCrawlService.saveBatch(importantProjectCrawlInfos);
    }

    public void appendRules(List<ImportantProject> importantProjectInDB, Long ruleId) {
        log.debug("Request to append ruleId for important projects, ruleId={}", (Object)ruleId);
        for (ImportantProject importantProject : importantProjectInDB) {
            HashSet<Long> rules = new HashSet<Long>();
            if (CollectionUtils.isNotEmpty((Collection)importantProject.getRules())) {
                rules.addAll(importantProject.getRules());
            }
            rules.add(ruleId);
            this.importantProjectMapper.updateImportantRules(importantProject.getId(), StringUtils.joinWith((String)",", (Object[])new Object[]{rules}));
        }
    }

    public ImportantProjectProfileResp profile(String id) {
        ImportantProject importantProject = (ImportantProject)this.importantProjectMapper.selectById((Serializable)((Object)id));
        ImportantProjectProfileResp importantProjectProfileResp = new ImportantProjectProfileResp();
        BeanUtils.copyProperties((Object)importantProject, (Object)importantProjectProfileResp);
        ImportantProjectReleaseReq req = new ImportantProjectReleaseReq();
        req.setOrderBy("pt");
        req.setSortBy("desc");
        req.setPageNum(Integer.valueOf(1));
        req.setPageSize(Integer.valueOf(3));
        Page importantProjectReleasePage = this.importantProjectReleaseService.selectReleasePage(req);
        ArrayList releases = new ArrayList();
        importantProjectReleasePage.getRecords().forEach(data -> {
            ImportantProjectProfileResp.Release release = new ImportantProjectProfileResp.Release();
            release.setTag(data.getTag());
            release.setDt(data.getPt());
            releases.add(release);
        });
        importantProjectProfileResp.setReleases(releases);
        importantProjectProfileResp.setReleasesSize(Long.valueOf(importantProjectReleasePage.getTotal()));
        return importantProjectProfileResp;
    }

    public PageDTO<ImportantProjectRelease> releaseDetail(ImportantProjectReleaseReq req) {
        Page importantProjectReleasePage = this.importantProjectReleaseService.selectReleasePage(req);
        return new PageDTO(Long.valueOf(importantProjectReleasePage.getTotal()), importantProjectReleasePage.getRecords());
    }

    public ImportantProjectTypeCountResp getTypeCount(Long id) {
        ImportantProject importantProject = (ImportantProject)this.importantProjectMapper.selectById((Serializable)id);
        ImportantProjectTypeCountResp importantProjectTypeCountResp = new ImportantProjectTypeCountResp();
        BeanUtils.copyProperties((Object)importantProject, (Object)importantProjectTypeCountResp);
        List szMirrorSites = this.mirrorSiteService.selectByFullNameAndType("sz", importantProject.getFullName());
        List szSites = szMirrorSites.stream().map(MirrorSite::getId).collect(Collectors.toList());
        importantProjectTypeCountResp.setSzSites(szSites);
        List airPortMirrorSites = this.mirrorSiteService.selectByFullNameAndType("airPort", importantProject.getFullName());
        List airPortSites = airPortMirrorSites.stream().map(MirrorSite::getId).collect(Collectors.toList());
        importantProjectTypeCountResp.setAirportSites(airPortSites);
        List resourceUrls = this.resourceUrlService.selectByFullNameAndType("resource_url", importantProject.getFullName());
        List resources = resourceUrls.stream().map(ResourceUrl::getId).collect(Collectors.toList());
        importantProjectTypeCountResp.setResources(resources);
        List subscriptionUrl = this.resourceUrlService.selectByFullNameAndType("subscription_url", importantProject.getFullName());
        List subscriptionUrls = subscriptionUrl.stream().map(ResourceUrl::getId).collect(Collectors.toList());
        importantProjectTypeCountResp.setSubscriptionUrls(subscriptionUrls);
        return importantProjectTypeCountResp;
    }
}

