/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.service;

import cn.ict.githubserver.config.ApplicationProperties;
import cn.ict.githubserver.domain.req.RuleExecutorReq;
import cn.ict.githubserver.domain.req.RuleReq;
import cn.ict.githubserver.entity.PublicProject;
import cn.ict.githubserver.entity.Rule;
import cn.ict.githubserver.entity.RuleExecuteRecord;
import cn.ict.githubserver.entity.RuleExecutor;
import cn.ict.githubserver.entity.enums.RuleExecutorStatus;
import cn.ict.githubserver.service.ImportantProjectService;
import cn.ict.githubserver.service.ProjectRuleService;
import cn.ict.githubserver.service.PublicProjectService;
import cn.ict.githubserver.service.RuleExecuteRecordService;
import cn.ict.githubserver.service.RuleExecutorService;
import cn.ict.githubserver.service.RuleProcessor;
import cn.ict.githubserver.service.RuleService;
import jakarta.annotation.PostConstruct;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RuleScheduleService {
    private static final Logger log = LoggerFactory.getLogger(RuleScheduleService.class);
    private final Instant initTime = Instant.now();
    private static final int MAX_PARALLEL_INSTANCE = 3;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private RuleService ruleService;
    @Autowired
    @Qualifier(value="ruleTaskExecutor")
    private TaskExecutor taskExecutor;
    @Autowired
    private RuleExecuteRecordService executeRecordService;
    @Autowired
    private RuleExecutorService ruleExecutorService;
    @Autowired
    private PublicProjectService publicProjectService;
    @Autowired
    private ProjectRuleService projectRuleService;
    @Autowired
    private ImportantProjectService importantProjectService;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private final Map<Long, Rule> cachedRule = new HashMap();
    private final Map<Long, AtomicInteger> ruleSemaphores = new HashMap();
    private final Map<Long, BlockingDeque<Long>> ruleMatchedProjectsMap = new HashMap();

    @PostConstruct
    public void init() {
        log.debug("init rule background service...");
        this.closeUnactiveRuleExecutor();
    }

    public void closeUnactiveRuleExecutor() {
        log.debug("closing unactive rule executors....");
        RuleExecutorReq ruleExecutorReq = new RuleExecutorReq();
        ruleExecutorReq.setStatus(Integer.valueOf(RuleExecutorStatus.RUNNING.getVal()));
        List ruleExecutors = this.ruleExecutorService.list(ruleExecutorReq);
        if (CollectionUtils.isEmpty((Collection)ruleExecutors)) {
            return;
        }
        Set ruleIds = ruleExecutors.stream().map(RuleExecutor::getRuleId).collect(Collectors.toSet());
        RuleReq ruleReq = new RuleReq();
        ruleReq.setIds(new ArrayList(ruleIds));
        ruleReq.setActive(Boolean.valueOf(false));
        List rules = this.ruleService.list(ruleReq);
        if (CollectionUtils.isEmpty((Collection)rules)) {
            return;
        }
        Set unactiveRuleIds = rules.stream().map(Rule::getId).collect(Collectors.toSet());
        for (RuleExecutor ruleExecutor : ruleExecutors) {
            if (!unactiveRuleIds.contains(ruleExecutor.getRuleId())) continue;
            this.ruleExecutorService.updateStatus(ruleExecutor, RuleExecutorStatus.FINISHED.getVal());
        }
    }

    @Scheduled(fixedDelay=60000L)
    public void scheduleRules() {
        log.debug("start rule scheduler...");
        this.ruleService.findActiveRules().forEach(rule -> {
            Rule oldRule = this.cachedRule.put(rule.getId(), rule);
            if (oldRule != null && oldRule.getMaxParallel() != rule.getMaxParallel()) {
                AtomicInteger sem = (AtomicInteger)this.ruleSemaphores.get(rule.getId());
                sem.getAndAdd(rule.getMaxParallel() - oldRule.getMaxParallel());
            }
            if (this.shouldSchedule(rule) && this.acquireSlot(rule)) {
                this.ruleService.updateLastScheduleTime(rule);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error("sleep interrupted!!!!!!!", (Throwable)e);
                }
                BlockingDeque matchedProjectIds = this.ruleMatchedProjectsMap.computeIfAbsent(rule.getId(), k -> new LinkedBlockingDeque(this.applicationProperties.getRulePlanLength()));
                this.taskExecutor.execute(() -> {
                    try {
                        RuleExecutor ruleExecutor = this.ruleExecutorService.generateExecutor(rule);
                        try {
                            RuleProcessor ruleProcessor = new RuleProcessor(rule, matchedProjectIds);
                            this.process(ruleExecutor, ruleProcessor);
                            log.info("executor finished task: rule_id={}, executor={}", (Object)rule.getId(), (Object)ruleExecutor);
                            this.ruleExecutorService.updateStatus(ruleExecutor, RuleExecutorStatus.FINISHED.getVal());
                        }
                        catch (Exception e) {
                            log.error("processing rule error, rule={}", rule, (Object)e);
                            this.ruleExecutorService.updateStatus(ruleExecutor, RuleExecutorStatus.ERROR.getVal());
                        }
                    }
                    catch (Exception e) {
                        log.error("create rule Executor error!", (Throwable)e);
                    }
                    finally {
                        log.debug("release processing slot, rule={}", rule);
                        this.releaseSlot(rule);
                    }
                });
            }
        });
        log.debug("scheduled over!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(RuleExecutor ruleExecutor, RuleProcessor ruleProcessor) {
        log.debug("start processing: {}", (Object)ruleExecutor);
        RuleExecuteRecord segment = this.executeRecordService.getOrGenerateExecuteRecord(ruleExecutor);
        while (segment != null && !this.shutdown.get()) {
            long process = 0L;
            long target = 0L;
            long lastUpdate = System.currentTimeMillis();
            BlockingDeque matchedQueue = this.ruleMatchedProjectsMap.computeIfAbsent(ruleExecutor.getRuleId(), k -> new LinkedBlockingDeque(this.applicationProperties.getRulePlanLength()));
            try {
                long idx = segment.getProjectIdFrom();
                ArrayList<Long> matchedProjectIds = new ArrayList<Long>();
                while (idx <= segment.getProjectIdTo()) {
                    long end = Math.min(idx + (long)this.applicationProperties.getRuleExecuteBatch(), segment.getProjectIdTo());
                    List publicProjects = this.publicProjectService.getByIds(idx, end);
                    log.debug("processing projects, num={}", (Object)publicProjects.size());
                    for (PublicProject project : publicProjects) {
                        ruleProcessor.process(project);
                    }
                    process += (long)publicProjects.size();
                    while (!matchedQueue.isEmpty()) {
                        try {
                            Long projectId = (Long)matchedQueue.poll(1L, TimeUnit.SECONDS);
                            if (projectId != null) {
                                matchedProjectIds.add(projectId);
                            }
                            if (matchedProjectIds.size() < 1000 && System.currentTimeMillis() - lastUpdate < 5000L) continue;
                            log.debug("updating project rule relations");
                            target += (long)matchedProjectIds.size();
                            this.projectRuleService.updateAll(ruleExecutor.getRuleId(), matchedProjectIds);
                            this.importantProjectService.newImportantProjects(ruleExecutor.getRuleId(), matchedProjectIds);
                            matchedProjectIds.clear();
                            lastUpdate = System.currentTimeMillis();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    target += (long)matchedProjectIds.size();
                    this.projectRuleService.updateAll(ruleExecutor.getRuleId(), matchedProjectIds);
                    matchedProjectIds.clear();
                    idx = end + 1L;
                }
                this.executeRecordService.finishedExecuteRecord(segment, target, process);
            }
            catch (RuntimeException e) {
                log.debug("execute rule segment error!", (Throwable)e);
                this.executeRecordService.errorExecuteRecord(segment, target, process);
            }
            finally {
                this.ruleExecutorService.updateSegment(ruleExecutor, segment);
            }
            segment = this.executeRecordService.getOrGenerateExecuteRecord(ruleExecutor);
        }
    }

    private boolean acquireSlot(Rule rule) {
        AtomicInteger semaphore = this.ruleSemaphores.computeIfAbsent(rule.getId(), k -> new AtomicInteger(rule.getMaxParallel()));
        return semaphore.decrementAndGet() >= 0;
    }

    private void releaseSlot(Rule rule) {
        int remainParallel = ((AtomicInteger)this.ruleSemaphores.get(rule.getId())).incrementAndGet();
        log.debug("rule={} can schedule {} threads!", (Object)rule.getId(), (Object)remainParallel);
    }

    private boolean shouldSchedule(Rule rule) {
        Optional lastScheduleTimeOp = this.ruleService.getScheduleTime(rule.getId());
        Instant lastScheduleTime = lastScheduleTimeOp.orElse(Instant.MIN);
        return lastScheduleTime.isBefore(this.initTime) || lastScheduleTime.plusMillis(rule.getInterval()).isBefore(Instant.now());
    }

    public void close() {
        this.shutdown.compareAndSet(false, true);
        ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)this.taskExecutor;
        int activeThreads = executor.getActiveCount();
        while (activeThreads > 0) {
            log.debug("task executor status: active_threads={}", (Object)activeThreads);
            try {
                Thread.sleep(60000L);
                activeThreads = executor.getActiveCount();
            }
            catch (InterruptedException e) {
                log.error("closing error...", (Throwable)e);
            }
        }
    }
}

