/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.service;

import cn.ict.githubserver.config.ApplicationConfig;
import cn.ict.githubserver.domain.dto.RuleDTO;
import cn.ict.githubserver.entity.PublicProject;
import cn.ict.githubserver.entity.Rule;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingDeque;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.api.RulesEngine;
import org.jeasy.rules.api.RulesEngineParameters;
import org.jeasy.rules.core.DefaultRulesEngine;
import org.jeasy.rules.core.RuleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RuleProcessor {
    private static final Logger log = LoggerFactory.getLogger(RuleProcessor.class);
    private final Rule busiRule;
    private final Rules rules = new Rules(new org.jeasy.rules.api.Rule[0]);
    private final RulesEngine rulesEngine;
    private final BlockingDeque<Long> matchedProjectIds;
    private final Facts facts = new Facts();

    public RuleProcessor(Rule busiRule, BlockingDeque<Long> matchedProjectIds) {
        this.busiRule = busiRule;
        this.matchedProjectIds = matchedProjectIds;
        this.rules.register(new Object[]{RuleProcessor.compileRule((Rule)this.busiRule, (BlockingDeque)this.matchedProjectIds).orElseThrow()});
        RulesEngineParameters parameters = new RulesEngineParameters().skipOnFirstAppliedRule(true);
        this.rulesEngine = new DefaultRulesEngine(parameters);
    }

    public static Optional<RuleDTO> parseRule(Rule rule) {
        log.debug("parsing rule: {}", (Object)rule);
        String condition = rule.getCondition().strip();
        RuleDTO ruleDTO = null;
        try {
            if (condition.isEmpty()) {
                log.warn("[RULE]: not effective rule! rule={}", (Object)rule);
            } else {
                if (condition.startsWith("{")) {
                    ruleDTO = (RuleDTO)ApplicationConfig.om.readValue(condition, RuleDTO.class);
                } else {
                    List<String> params = null;
                    params = condition.startsWith("[") ? (List<String>)ApplicationConfig.om.readValue(condition, (TypeReference)new /* Unavailable Anonymous Inner Class!! */) : Stream.of(org.apache.commons.lang3.StringUtils.split((String)condition, (String)",")).map(String::strip).filter(Predicate.not(String::isEmpty)).toList();
                    ruleDTO = new RuleDTO(params, params, params);
                }
                ruleDTO.setDesc(ruleDTO.getDesc().stream().map(String::toLowerCase).toList());
                ruleDTO.setUserLogin(ruleDTO.getUserLogin().stream().map(String::toLowerCase).toList());
                ruleDTO.setFullName(ruleDTO.getFullName().stream().map(String::toLowerCase).toList());
            }
        }
        catch (Exception e) {
            log.error("[RULE]: parse rule error!, rule={}", (Object)rule, (Object)e);
        }
        return Optional.ofNullable(ruleDTO);
    }

    public static Optional<org.jeasy.rules.api.Rule> compileRule(Rule rule, BlockingDeque<Long> matchedProjectIds) {
        Optional ruleDTOOptional = RuleProcessor.parseRule((Rule)rule);
        return ruleDTOOptional.map(ruleDTO -> new RuleBuilder().name(String.valueOf(rule.getId())).when(facts -> {
            PublicProject project = (PublicProject)facts.get("project");
            log.debug("matching: rule={}, project={}", ruleDTO, (Object)project);
            return ruleDTO.getFullName().stream().anyMatch(s -> StringUtils.hasText((String)project.getFullName()) && project.getFullName().toLowerCase().contains((CharSequence)s)) || ruleDTO.getUserLogin().stream().anyMatch(s -> StringUtils.hasText((String)project.getUserLogin()) && project.getUserLogin().toLowerCase().contains((CharSequence)s)) || ruleDTO.getDesc().stream().anyMatch(s -> StringUtils.hasText((String)project.getDesc()) && project.getDesc().toLowerCase().contains((CharSequence)s));
        }).then(facts -> {
            PublicProject project = (PublicProject)facts.get("project");
            System.out.println("@@@@@@@@[TARGET]: " + project);
            matchedProjectIds.addFirst(project.getId());
        }).build());
    }

    public void process(PublicProject project) {
        log.debug("[RULE] rule_id={} processing:  {}", (Object)this.busiRule.getId(), (Object)project);
        System.out.println("@@@@@@@[PROCESSING]:" + project);
        this.facts.put("project", (Object)project);
        this.rulesEngine.fire(this.rules, this.facts);
    }
}

