/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.service;

import cn.ict.githubserver.config.ApplicationConfig;
import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.RuleDetailReq;
import cn.ict.githubserver.domain.req.RuleExecutorReq;
import cn.ict.githubserver.domain.resp.RuleExecutorResp;
import cn.ict.githubserver.entity.Rule;
import cn.ict.githubserver.entity.RuleExecuteRecord;
import cn.ict.githubserver.entity.RuleExecutor;
import cn.ict.githubserver.entity.enums.RuleExecutorStatus;
import cn.ict.githubserver.mapper.RuleExecutorMapper;
import cn.ict.githubserver.util.TimeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RuleExecutorService
extends ServiceImpl<RuleExecutorMapper, RuleExecutor> {
    private static final Logger log = LoggerFactory.getLogger(RuleExecutorService.class);
    @Autowired
    private RuleExecutorMapper ruleExecutorMapper;

    LambdaQueryWrapper<RuleExecutor> query(RuleExecutorReq ruleExecutorReq) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(RuleExecutor.class);
        if (ruleExecutorReq.getId() != null) {
            queryWrapper.eq(RuleExecutor::getId, (Object)ruleExecutorReq.getId());
        }
        if (ruleExecutorReq.getRuleId() != null) {
            queryWrapper.eq(RuleExecutor::getRuleId, (Object)ruleExecutorReq.getRuleId());
        }
        if (ruleExecutorReq.getStartTime() != null) {
            queryWrapper.eq(RuleExecutor::getStartTime, (Object)ApplicationConfig.formatter.format(ruleExecutorReq.getStartTime()));
        }
        if (ruleExecutorReq.getEndTime() != null) {
            queryWrapper.eq(RuleExecutor::getEndTime, (Object)ApplicationConfig.formatter.format(ruleExecutorReq.getEndTime()));
        }
        if (ruleExecutorReq.getDuration() != null) {
            queryWrapper.eq(RuleExecutor::getDuration, (Object)ruleExecutorReq.getDuration());
        }
        return queryWrapper;
    }

    @Transactional(readOnly=true)
    public List<RuleExecutor> list(RuleExecutorReq ruleExecutorReq) {
        return this.list((Wrapper)this.query(ruleExecutorReq));
    }

    @Transactional(readOnly=true)
    public Optional<Long> getId(RuleExecutor ruleExecutor) {
        RuleExecutorReq ruleExecutorReq = new RuleExecutorReq();
        ruleExecutorReq.setRuleId(ruleExecutor.getRuleId());
        ruleExecutorReq.setStartTime(ruleExecutor.getStartTime());
        return this.getOneOpt((Wrapper)this.query(ruleExecutorReq)).map(RuleExecutor::getId);
    }

    public RuleExecutor generateExecutor(Rule rule) {
        log.debug("generate rule executor, rule={}", (Object)rule);
        RuleExecutor ruleExecutor = new RuleExecutor();
        ruleExecutor.setRuleId(rule.getId());
        ruleExecutor.setDuration(Long.valueOf(0L));
        ruleExecutor.setProcessedNum(Long.valueOf(0L));
        ruleExecutor.setTargetNum(Long.valueOf(0L));
        ruleExecutor.setStatus(Integer.valueOf(RuleExecutorStatus.RUNNING.getVal()));
        ruleExecutor.setStartTime(TimeUtil.now());
        this.save((Object)ruleExecutor);
        Optional id = this.getId(ruleExecutor);
        ruleExecutor.setId((Long)id.orElseThrow());
        return ruleExecutor;
    }

    public synchronized RuleExecutor updateSegment(RuleExecutor ruleExecutor, RuleExecuteRecord segment) {
        log.debug("update executor processing status: segment={}", (Object)segment);
        ruleExecutor.setDuration(Long.valueOf(ruleExecutor.getDuration() + segment.getDuration()));
        ruleExecutor.setEndTime(Instant.now());
        ruleExecutor.setProcessedNum(Long.valueOf(ruleExecutor.getProcessedNum() + segment.getProcesseNum()));
        ruleExecutor.setTargetNum(Long.valueOf(ruleExecutor.getTargetNum() + segment.getTargetNum()));
        this.saveOrUpdate((Object)ruleExecutor);
        return ruleExecutor;
    }

    public RuleExecutor updateStatus(RuleExecutor ruleExecutor, int status) {
        log.debug("update executor status to : {}", (Object)status);
        ruleExecutor.setStatus(Integer.valueOf(status));
        this.saveOrUpdate((Object)ruleExecutor);
        return ruleExecutor;
    }

    public PageDTO<RuleExecutorResp> ruleDetail(RuleDetailReq ruleDetailReq) {
        LambdaQueryWrapper lambdaQueryWrapper = this.getQueryByRuleDetail(ruleDetailReq);
        Page page = new Page((long)ruleDetailReq.getPageNum().intValue(), (long)ruleDetailReq.getPageSize().intValue());
        Page ruleExecutorPage = (Page)this.ruleExecutorMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
        List ruleExecutorRespList = ruleExecutorPage.getRecords().stream().map(rule -> {
            RuleExecutorResp ruleExecutorResp = new RuleExecutorResp();
            BeanUtils.copyProperties((Object)rule, (Object)ruleExecutorResp);
            double efficiency = (double)rule.getTargetNum().longValue() / (double)(rule.getDuration() * 3600000L);
            ruleExecutorResp.setDiscoverEfficiency(Double.valueOf((double)Math.round(efficiency * 100.0) / 100.0));
            return ruleExecutorResp;
        }).collect(Collectors.toList());
        return new PageDTO(Long.valueOf(page.getTotal()), ruleExecutorRespList);
    }

    private LambdaQueryWrapper getQueryByRuleDetail(RuleDetailReq ruleDetailReq) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (Objects.nonNull(ruleDetailReq.getRuleId())) {
            queryWrapper.eq(RuleExecutor::getRuleId, (Object)ruleDetailReq.getRuleId());
        }
        if (Objects.nonNull(ruleDetailReq.getStartTimeStart())) {
            queryWrapper.ge(RuleExecutor::getStartTime, (Object)ruleDetailReq.getStartTimeStart());
        }
        if (Objects.nonNull(ruleDetailReq.getStartTimeEnd())) {
            queryWrapper.le(RuleExecutor::getStartTime, (Object)ruleDetailReq.getStartTimeEnd());
        }
        if (Objects.nonNull(ruleDetailReq.getEndTimeStart())) {
            queryWrapper.ge(RuleExecutor::getEndTime, (Object)ruleDetailReq.getEndTimeStart());
        }
        if (Objects.nonNull(ruleDetailReq.getEndTimeEnd())) {
            queryWrapper.le(RuleExecutor::getEndTime, (Object)ruleDetailReq.getEndTimeEnd());
        }
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("ruleId", RuleExecutor::getRuleId);
        fieldMap.put("startTime", RuleExecutor::getStartTime);
        fieldMap.put("endTime", RuleExecutor::getEndTime);
        fieldMap.put("endTime", RuleExecutor::getEndTime);
        fieldMap.put("duration", RuleExecutor::getDuration);
        fieldMap.put("targetNum", RuleExecutor::getTargetNum);
        fieldMap.put("processNum", RuleExecutor::getProcessedNum);
        if (StringUtils.isNotEmpty((CharSequence)ruleDetailReq.getOrderBy())) {
            if ("desc".equals(ruleDetailReq.getSortBy())) {
                queryWrapper.orderByDesc((Object)((SFunction)fieldMap.get(ruleDetailReq.getOrderBy())));
            } else {
                queryWrapper.orderByAsc((Object)((SFunction)fieldMap.get(ruleDetailReq.getOrderBy())));
            }
        }
        return queryWrapper;
    }

    public PageDTO<RuleExecutorResp> execStatistics(RuleDetailReq ruleDetailReq) {
        Page page = new Page((long)ruleDetailReq.getPageNum().intValue(), (long)ruleDetailReq.getPageSize().intValue());
        Page pageRes = this.ruleExecutorMapper.execStatistics(page, ruleDetailReq);
        return new PageDTO(Long.valueOf(pageRes.getTotal()), pageRes.getRecords());
    }
}

