/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.service;

import cn.ict.githubserver.config.ApplicationConfig;
import cn.ict.githubserver.config.ApplicationProperties;
import cn.ict.githubserver.domain.req.RuleExecuteRecordReq;
import cn.ict.githubserver.entity.PublicProject;
import cn.ict.githubserver.entity.RuleExecuteRecord;
import cn.ict.githubserver.entity.RuleExecutor;
import cn.ict.githubserver.entity.enums.ExecuteRecordStatus;
import cn.ict.githubserver.mapper.ExecutRecordMapper;
import cn.ict.githubserver.service.PublicProjectService;
import cn.ict.githubserver.util.TimeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class RuleExecuteRecordService
extends ServiceImpl<ExecutRecordMapper, RuleExecuteRecord> {
    private static final Logger log = LoggerFactory.getLogger(RuleExecuteRecordService.class);
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private ExecutRecordMapper executRecordMapper;
    @Autowired
    private PublicProjectService publicProjectService;

    LambdaQueryWrapper<RuleExecuteRecord> query(RuleExecuteRecordReq ruleExecuteRecordReq) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(RuleExecuteRecord.class);
        if (ruleExecuteRecordReq.getId() != null) {
            queryWrapper.eq(RuleExecuteRecord::getId, (Object)ruleExecuteRecordReq.getId());
        }
        if (ruleExecuteRecordReq.getRuleId() != null) {
            queryWrapper.eq(RuleExecuteRecord::getRuleId, (Object)ruleExecuteRecordReq.getRuleId());
        }
        if (ruleExecuteRecordReq.getExecutorId() != null) {
            queryWrapper.eq(RuleExecuteRecord::getExecutorId, (Object)ruleExecuteRecordReq.getExecutorId());
        }
        if (ruleExecuteRecordReq.getStartTime() != null) {
            queryWrapper.eq(RuleExecuteRecord::getStartTime, (Object)ApplicationConfig.formatter.format(ruleExecuteRecordReq.getStartTime()));
        }
        if (ruleExecuteRecordReq.getEndTime() != null) {
            queryWrapper.eq(RuleExecuteRecord::getEndTime, (Object)ApplicationConfig.formatter.format(ruleExecuteRecordReq.getEndTime()));
        }
        if (ruleExecuteRecordReq.getProjectIdFrom() != null) {
            queryWrapper.eq(RuleExecuteRecord::getProjectIdFrom, (Object)ruleExecuteRecordReq.getProjectIdFrom());
        }
        if (ruleExecuteRecordReq.getProjectIdTo() != null) {
            queryWrapper.eq(RuleExecuteRecord::getProjectIdTo, (Object)ruleExecuteRecordReq.getProjectIdTo());
        }
        if (ruleExecuteRecordReq.getDuration() != null) {
            queryWrapper.eq(RuleExecuteRecord::getDuration, (Object)ruleExecuteRecordReq.getDuration());
        }
        return queryWrapper;
    }

    @Transactional(readOnly=true)
    public RuleExecuteRecord getMaxProjectIdTo(long ruleId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RuleExecuteRecord::getRuleId, (Object)ruleId);
        ((LambdaQueryWrapper)wrapper.orderByDesc(RuleExecuteRecord::getProjectIdTo)).last("LIMIT 1");
        return (RuleExecuteRecord)this.executRecordMapper.selectOne((Wrapper)wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RuleExecuteRecord getOrGenerateExecuteRecord(RuleExecutor ruleExecutor) {
        log.debug("Request to get error status or create new ExecutorRecord! ruleExecutor={}", (Object)ruleExecutor);
        RuleExecutor ruleExecutor2 = ruleExecutor;
        synchronized (ruleExecutor2) {
            List unfinishedExecutorRecords = this.executRecordMapper.getUnfinishedExecuteRecord(ruleExecutor.getRuleId());
            return CollectionUtils.isEmpty((Collection)unfinishedExecutorRecords) ? this.generateExecuteRecord(ruleExecutor) : (RuleExecuteRecord)unfinishedExecutorRecords.get(0);
        }
    }

    public RuleExecuteRecord generateExecuteRecord(RuleExecutor ruleExecutor) {
        log.debug("generate execute record by executor: {}", (Object)ruleExecutor);
        PublicProject minIdProject = this.publicProjectService.getMinProjectId();
        RuleExecuteRecord maxToProjectIdRecord = this.getMaxProjectIdTo(ruleExecutor.getRuleId().longValue());
        long from = maxToProjectIdRecord == null ? minIdProject.getId() : maxToProjectIdRecord.getProjectIdTo() + 1L;
        PublicProject maxIdPublicProject = this.publicProjectService.getMaxProjectId();
        long to = Math.min(maxIdPublicProject.getId(), from + (long)this.applicationProperties.getRulePlanLength());
        log.debug("expect next segment: [{}, {}], projectId=[{}, {}], maxToProjectIdRecord={}", new Object[]{from, to, minIdProject.getId(), maxIdPublicProject.getId(), maxToProjectIdRecord});
        System.out.println("@@@@@!!!!!! expect next segment: [" + from + ", " + to + "], projectId=[" + minIdProject.getId() + ", " + maxIdPublicProject.getId() + "], maxToProjectIdRecord=" + maxToProjectIdRecord);
        if (from > to) {
            return null;
        }
        Instant now = TimeUtil.now();
        RuleExecuteRecord executeRecord = new RuleExecuteRecord(null, ruleExecutor.getRuleId(), ruleExecutor.getId(), Long.valueOf(from), Long.valueOf(to), now, null, Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(ExecuteRecordStatus.INIT.getVal()));
        this.saveOrUpdate((Object)executeRecord);
        Optional id = this.getId(executeRecord);
        executeRecord.setId((Long)id.orElseThrow());
        return executeRecord;
    }

    private Optional<Long> getId(RuleExecuteRecord executeRecord) {
        RuleExecuteRecordReq ruleExecuteRecordReq = new RuleExecuteRecordReq();
        ruleExecuteRecordReq.setRuleId(executeRecord.getRuleId());
        ruleExecuteRecordReq.setExecutorId(executeRecord.getExecutorId());
        ruleExecuteRecordReq.setProjectIdFrom(executeRecord.getProjectIdFrom());
        ruleExecuteRecordReq.setProjectIdTo(executeRecord.getProjectIdTo());
        return this.getOneOpt((Wrapper)this.query(ruleExecuteRecordReq)).map(RuleExecuteRecord::getId);
    }

    public synchronized void finishedExecuteRecord(RuleExecuteRecord segment, long target, long process) {
        RuleExecuteRecord executeRecord = this.fillExecuteRecord(segment, target, process);
        executeRecord.setStatus(Integer.valueOf(ExecuteRecordStatus.FINISHED.getVal()));
        this.save((Object)executeRecord);
    }

    public synchronized void errorExecuteRecord(RuleExecuteRecord segment, long target, long process) {
        RuleExecuteRecord executeRecord = this.fillExecuteRecord(segment, target, process);
        executeRecord.setStatus(Integer.valueOf(ExecuteRecordStatus.ERROR.getVal()));
        this.save((Object)executeRecord);
    }

    private RuleExecuteRecord fillExecuteRecord(RuleExecuteRecord segment, long target, long process) {
        Instant now = Instant.now();
        segment.setTargetNum(Long.valueOf(target));
        segment.setProcesseNum(Long.valueOf(process));
        segment.setEndTime(now);
        segment.setDuration(Long.valueOf(now.toEpochMilli() - segment.getStartTime().toEpochMilli()));
        return segment;
    }
}

