/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.handler;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class GenericJsonTypeHandler<T>
extends BaseTypeHandler<T> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final JavaType javaType;

    public GenericJsonTypeHandler(Class<T> type) {
        this.javaType = OBJECT_MAPPER.getTypeFactory().constructType(type);
    }

    public GenericJsonTypeHandler(Class<? extends Collection> collectionClass, Class<?> elementClass) {
        this.javaType = OBJECT_MAPPER.getTypeFactory().constructCollectionType(collectionClass, elementClass);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        try {
            ps.setString(i, OBJECT_MAPPER.writeValueAsString(parameter));
        }
        catch (Exception e) {
            throw new SQLException("Error converting object to JSON string", e);
        }
    }

    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return (T)this.parseJson(rs.getString(columnName));
    }

    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return (T)this.parseJson(rs.getString(columnIndex));
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return (T)this.parseJson(cs.getString(columnIndex));
    }

    private T parseJson(String json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, this.javaType);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing JSON string: " + json, e);
        }
    }

    static {
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

