/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class BigIntArrayTypeHandler
extends BaseTypeHandler<List<Long>> {
    public void setNonNullParameter(PreparedStatement ps, int i, List<Long> parameter, JdbcType jdbcType) throws SQLException {
        String typeName = "array<bigint>";
        if (parameter == null || parameter.isEmpty()) {
            ps.setString(i, "[]");
        } else {
            String joined = parameter.stream().map(String::valueOf).collect(Collectors.joining(","));
            String arrayStr = "[" + joined + "]";
            ps.setString(i, arrayStr);
        }
    }

    public List<Long> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.parseArrayString(rs.getString(columnName));
    }

    public List<Long> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.parseArrayString(rs.getString(columnIndex));
    }

    public List<Long> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.parseArrayString(cs.getString(columnIndex));
    }

    private List<Long> parseArrayString(String arrayStr) {
        if (arrayStr == null || arrayStr.trim().isEmpty() || "null".equalsIgnoreCase(arrayStr)) {
            return null;
        }
        String[] items = arrayStr.replace("[", "").replace("]", "").split(",");
        return Arrays.stream(items).map(String::trim).filter(s -> !s.isEmpty()).map(Long::valueOf).collect(Collectors.toList());
    }
}

