/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.exception;

import cn.ict.githubserver.domain.WebResult;
import cn.ict.githubserver.exception.MyException;
import jakarta.validation.ConstraintViolationException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestControllerAdvice(value={"cn.ict.githubserver.controller"})
public class ExceptionController {
    private static final Logger log = LoggerFactory.getLogger(ExceptionController.class);

    @ExceptionHandler(value={NullPointerException.class})
    public WebResult nullPointException(NullPointerException e) {
        log.error("EXCEPTION ADVICE", (Throwable)e);
        WebResult response = new WebResult();
        response.setCode(HttpStatus.BAD_REQUEST.value());
        response.setMessage(e.getMessage());
        return response;
    }

    @ExceptionHandler(value={HttpClientErrorException.BadRequest.class})
    public WebResult baseRequest(HttpClientErrorException.BadRequest e) {
        log.error("EXCEPTION ADVICE", (Throwable)e);
        WebResult response = new WebResult();
        response.setCode(HttpStatus.BAD_REQUEST.value());
        response.setMessage(e.getMessage());
        return response;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public WebResult missingParams(MissingServletRequestParameterException e) {
        log.error("EXCEPTION ADVICE", (Throwable)e);
        WebResult response = new WebResult();
        response.setCode(HttpStatus.BAD_REQUEST.value());
        response.setMessage(e.getMessage());
        return response;
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public WebResult missingParams(MethodArgumentTypeMismatchException e) {
        log.error("EXCEPTION ADVICE", (Throwable)e);
        WebResult response = new WebResult();
        response.setCode(HttpStatus.BAD_REQUEST.value());
        response.setMessage(e.getMessage());
        return response;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public WebResult handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error("EXCEPTION ADVICE", (Throwable)e);
        WebResult response = new WebResult();
        response.setCode(HttpStatus.BAD_REQUEST.value());
        String message = e.getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining());
        response.setMessage(message);
        return response;
    }

    @ExceptionHandler(value={BindException.class})
    public WebResult handleBindException(BindException e) {
        log.error("EXCEPTION ADVICE", (Throwable)e);
        WebResult response = new WebResult();
        response.setCode(HttpStatus.BAD_REQUEST.value());
        String message = e.getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining());
        response.setMessage(message);
        return response;
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public WebResult handleConstraintViolationException(ConstraintViolationException e) {
        log.error("EXCEPTION ADVICE", (Throwable)e);
        WebResult response = new WebResult();
        response.setCode(HttpStatus.BAD_REQUEST.value());
        response.setMessage(e.getMessage());
        return response;
    }

    @ExceptionHandler(value={MyException.class})
    public WebResult handleMyException(MyException e) {
        log.error("EXCEPTION ADVICE", (Throwable)e);
        WebResult response = new WebResult();
        response.setCode(-1);
        response.setMessage(e.getMessage());
        return response;
    }

    @ExceptionHandler(value={Exception.class})
    public WebResult allException(Exception e) {
        log.error("EXCEPTION ACTIVE", (Throwable)e);
        WebResult response = new WebResult();
        response.setCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
        response.setMessage(e.getMessage());
        return response;
    }
}

