/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.domain;

import cn.ict.githubserver.domain.WebResult;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="\u5168\u5c40\u54cd\u5e94")
public class WebResult<T> {
    @Schema(description="\u72b6\u6001\u7801", required=true, example="200")
    private int code;
    @Schema(description="\u4fe1\u606f", required=true, example="success")
    private String message;
    @Schema(description="\u6570\u636e")
    private T data;

    public static <T> WebResult<T> success(T data) {
        WebResult res = new WebResult();
        res.setCode(200);
        res.setMessage("success");
        res.setData(data);
        return res;
    }

    public static WebResult fail(String message) {
        WebResult res = new WebResult();
        res.setCode(500);
        res.setMessage(message);
        return res;
    }

    public static WebResult fail(int code, String message) {
        WebResult res = new WebResult();
        res.setCode(code);
        res.setMessage(message);
        return res;
    }

    public static <T> WebResultBuilder<T> builder() {
        return new WebResultBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebResult)) {
            return false;
        }
        WebResult other = (WebResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "WebResult(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public WebResult(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public WebResult() {
    }
}

