/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.covert;

import cn.ict.githubserver.covert.AttributeConvertUtil;
import cn.ict.githubserver.covert.SuspectedToolCovert;
import cn.ict.githubserver.domain.req.AddToolReq;
import cn.ict.githubserver.domain.req.QueryToolReq;
import cn.ict.githubserver.domain.resp.SuspectedToolResp;
import cn.ict.githubserver.entity.SuspectedTool;
import cn.ict.githubserver.entity.enums.FieldNamingStyle;
import cn.ict.githubserver.entity.enums.PlatformType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class SuspectedToolCovertImpl
implements SuspectedToolCovert {
    public List<SuspectedTool> toDbParam(List<QueryToolReq> reqList) {
        if (reqList == null) {
            return null;
        }
        ArrayList<SuspectedTool> list = new ArrayList<SuspectedTool>(reqList.size());
        for (QueryToolReq queryToolReq : reqList) {
            list.add(this.toDbParam(queryToolReq));
        }
        return list;
    }

    public void partialUpdate(SuspectedTool dbParam, QueryToolReq resp) {
        if (resp == null) {
            return;
        }
        if (resp.getToolName() != null) {
            dbParam.setToolName(resp.getToolName());
        }
        if (resp.getUrl() != null) {
            dbParam.setUrl(resp.getUrl());
        }
        if (resp.getOrderBy() != null) {
            dbParam.setOrderBy(resp.getOrderBy());
        }
        if (resp.getSortBy() != null) {
            dbParam.setSortBy(resp.getSortBy());
        }
        if (resp.getPushStartTime() != null) {
            dbParam.setPushStartTime(resp.getPushStartTime());
        }
        if (resp.getPushEndTime() != null) {
            dbParam.setPushEndTime(resp.getPushEndTime());
        }
        if (dbParam.getPlatformList() != null) {
            list = this.stringListToIntegerList(resp.getPlatformList());
            if (list != null) {
                dbParam.getPlatformList().clear();
                dbParam.getPlatformList().addAll(list);
            }
        } else {
            list = this.stringListToIntegerList(resp.getPlatformList());
            if (list != null) {
                dbParam.setPlatformList(list);
            }
        }
        if (dbParam.getPushStatusList() != null) {
            list1 = resp.getPushStatusList();
            if (list1 != null) {
                dbParam.getPushStatusList().clear();
                dbParam.getPushStatusList().addAll(list1);
            }
        } else {
            list1 = resp.getPushStatusList();
            if (list1 != null) {
                dbParam.setPushStatusList(new ArrayList(list1));
            }
        }
        if (dbParam.getIdList() != null) {
            list2 = resp.getIdList();
            if (list2 != null) {
                dbParam.getIdList().clear();
                dbParam.getIdList().addAll(list2);
            }
        } else {
            list2 = resp.getIdList();
            if (list2 != null) {
                dbParam.setIdList(new ArrayList(list2));
            }
        }
    }

    public SuspectedTool toDbParam(QueryToolReq req) {
        List list2;
        if (req == null) {
            return null;
        }
        SuspectedTool suspectedTool = new SuspectedTool();
        suspectedTool.setPlatformList(AttributeConvertUtil.platformNameToCodeList((List)req.getPlatformList()));
        suspectedTool.setFullName(req.getSourceProject());
        suspectedTool.setUserLogin(req.getSourceUser());
        if (req.getSortBy() != null) {
            suspectedTool.setSortBy(req.getSortBy());
        } else {
            suspectedTool.setSortBy("desc");
        }
        suspectedTool.setToolName(req.getToolName());
        suspectedTool.setUrl(req.getUrl());
        suspectedTool.setPushStartTime(req.getPushStartTime());
        suspectedTool.setPushEndTime(req.getPushEndTime());
        List list1 = req.getPushStatusList();
        if (list1 != null) {
            suspectedTool.setPushStatusList(new ArrayList(list1));
        }
        if ((list2 = req.getIdList()) != null) {
            suspectedTool.setIdList(new ArrayList(list2));
        }
        suspectedTool.setOrderBy(req.getOrderBy() == null || req.getOrderBy().isEmpty() ? "ft" : FieldNamingStyle.getSnakeCaseName((String)req.getOrderBy()));
        return suspectedTool;
    }

    public SuspectedToolResp toResp(SuspectedTool dbParam) {
        if (dbParam == null) {
            return null;
        }
        SuspectedToolResp suspectedToolResp = new SuspectedToolResp();
        suspectedToolResp.setSourceProject(dbParam.getFullName());
        suspectedToolResp.setSourceUser(dbParam.getUserLogin());
        suspectedToolResp.setPushTime(dbParam.getSt());
        suspectedToolResp.setPushStatus(dbParam.getSs());
        suspectedToolResp.setId(dbParam.getId());
        suspectedToolResp.setToolName(dbParam.getToolName());
        suspectedToolResp.setUrl(dbParam.getUrl());
        suspectedToolResp.setVersionNumber(dbParam.getVersionNumber());
        suspectedToolResp.setReleaseTime(dbParam.getReleaseTime());
        suspectedToolResp.setToolReleaseTime(dbParam.getToolReleaseTime());
        suspectedToolResp.setFt(dbParam.getFt());
        suspectedToolResp.setPlatform(PlatformType.getName((Integer)dbParam.getPlatform()));
        return suspectedToolResp;
    }

    public List<SuspectedToolResp> toResp(List<SuspectedTool> dbParam) {
        if (dbParam == null) {
            return null;
        }
        ArrayList<SuspectedToolResp> list = new ArrayList<SuspectedToolResp>(dbParam.size());
        for (SuspectedTool suspectedTool : dbParam) {
            list.add(this.toResp(suspectedTool));
        }
        return list;
    }

    public SuspectedTool addReqToDbParam(AddToolReq req) {
        if (req == null) {
            return null;
        }
        SuspectedTool suspectedTool = new SuspectedTool();
        suspectedTool.setFullName(req.getSourceProject());
        suspectedTool.setUserLogin(req.getSourceUser());
        suspectedTool.setId(req.getId());
        suspectedTool.setToolName(req.getToolName());
        suspectedTool.setUrl(req.getUrl());
        suspectedTool.setVersionNumber(req.getVersionNumber());
        suspectedTool.setReleaseTime(req.getReleaseTime());
        suspectedTool.setPackageName(req.getPackageName());
        suspectedTool.setToolReleaseTime(req.getToolReleaseTime());
        suspectedTool.setFt(req.getFt());
        suspectedTool.setPlatform(PlatformType.getCode((String)req.getPlatform()));
        return suspectedTool;
    }

    protected List<Integer> stringListToIntegerList(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Integer> list1 = new ArrayList<Integer>(list.size());
        for (String string : list) {
            list1.add(Integer.parseInt(string));
        }
        return list1;
    }
}

