/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.covert;

import cn.ict.githubserver.entity.enums.PlatformType;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Named;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AttributeConvertUtil {
    @Named(value="strToList")
    public List<String> strToList(String jsonString) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            return JSONArray.parseArray((String)jsonString, String.class);
        }
        return null;
    }

    @Named(value="listToStr")
    public String listToStr(List<String> list) {
        if (!CollectionUtils.isEmpty(list)) {
            return JSONArray.toJSONString(list, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        }
        return null;
    }

    @Named(value="platformNameToCodeList")
    public static List<Integer> platformNameToCodeList(List<String> platformList) {
        if (CollectionUtils.isEmpty(platformList)) {
            return Collections.emptyList();
        }
        return platformList.stream().map(PlatformType::getByName).filter(Objects::nonNull).map(PlatformType::getCode).collect(Collectors.toList());
    }
}

