/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.controller;

import cn.ict.githubserver.domain.WebResult;
import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.AddToolReq;
import cn.ict.githubserver.domain.req.QueryToolReq;
import cn.ict.githubserver.domain.resp.SuspectedToolResp;
import cn.ict.githubserver.service.SuspectedToolService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7591\u4f3c\u5de5\u5177")
@RestController
@RequestMapping(path={"/suspected-tool"})
public class SuspectedToolController {
    private static final Logger log = LoggerFactory.getLogger(SuspectedToolController.class);
    @Resource
    private SuspectedToolService suspectedToolService;

    @Operation(summary="\u5de5\u5177\u5217\u8868\u5c55\u793a")
    @PostMapping(value={"/list"})
    public WebResult<PageDTO<SuspectedToolResp>> list(@RequestBody @Validated QueryToolReq req) {
        PageDTO pageDTO = this.suspectedToolService.pageList(req);
        return WebResult.success((Object)pageDTO);
    }

    @Operation(summary="\u5de5\u5177\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    public WebResult<SuspectedToolResp> findInfo(@PathVariable Long id) {
        SuspectedToolResp resp = this.suspectedToolService.findInfo(id);
        return WebResult.success((Object)resp);
    }

    @Operation(summary="\u6dfb\u52a0\u5de5\u5177")
    @PostMapping(value={"/add"})
    public WebResult<Boolean> add(@RequestBody AddToolReq req) {
        req.setId(null);
        this.suspectedToolService.add(req);
        return WebResult.success((Object)true);
    }

    @Operation(summary="\u4fee\u6539\u5de5\u5177")
    @PostMapping(value={"/update"})
    public WebResult<Boolean> update(@RequestBody @Validated(value={AddToolReq.Update.class}) AddToolReq req) {
        this.suspectedToolService.update(req);
        return WebResult.success((Object)true);
    }

    @Operation(summary="\u5220\u9664\u5de5\u5177")
    @PostMapping(value={"/delete"})
    public WebResult<Boolean> delete(@RequestBody List<Long> idList) {
        this.suspectedToolService.delete(idList);
        return WebResult.success((Object)true);
    }

    @Operation(summary="\u5de5\u5177\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/download"})
    public void downLoadExcel(@RequestBody QueryToolReq req, HttpServletResponse response) throws IOException {
        String fileName = URLEncoder.encode("suspected_tool_export.xlsx", StandardCharsets.UTF_8);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        this.suspectedToolService.exportExcel(response.getOutputStream(), req);
    }

    @Operation(summary="\u6279\u91cf\u63a8\u9001")
    @PostMapping(value={"/push"})
    public WebResult<Boolean> push(@RequestBody List<Long> idList) {
        return WebResult.success((Object)true);
    }
}

