/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.controller;

import cn.ict.githubserver.domain.WebResult;
import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.QuerySampleReq;
import cn.ict.githubserver.domain.resp.SampleUrlResp;
import cn.ict.githubserver.service.SampleUrlService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u6837\u672c\u94fe\u63a5")
@RestController
@RequestMapping(path={"/sample-url"})
public class SampleUrlController {
    private static final Logger log = LoggerFactory.getLogger(SampleUrlController.class);
    @Resource
    private SampleUrlService sampleUrlService;

    @Operation(summary="\u6837\u672c\u94fe\u63a5\u5217\u8868\u5c55\u793a")
    @PostMapping(value={"/list"})
    public WebResult<PageDTO<SampleUrlResp>> list(@RequestBody @Validated QuerySampleReq req) {
        PageDTO pageDTO = this.sampleUrlService.pageList(req);
        return WebResult.success((Object)pageDTO);
    }

    @Operation(summary="\u6837\u672c\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    public WebResult<SampleUrlResp> findInfo(@PathVariable Long id) {
        SampleUrlResp resp = this.sampleUrlService.findInfo(id);
        return WebResult.success((Object)resp);
    }

    @Operation(summary="\u6837\u672c\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/download"})
    public void downLoadExcel(@RequestBody QuerySampleReq req, HttpServletResponse response) throws IOException {
        String fileName = URLEncoder.encode("sample_url_export.xlsx", StandardCharsets.UTF_8);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        this.sampleUrlService.exportExcel(response.getOutputStream(), req);
    }
}

