/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.controller;

import cn.ict.githubserver.domain.WebResult;
import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.RuleAddReq;
import cn.ict.githubserver.domain.req.RuleDetailReq;
import cn.ict.githubserver.domain.req.RuleReq;
import cn.ict.githubserver.domain.req.RuleStatisticsReq;
import cn.ict.githubserver.domain.resp.RuleResp;
import cn.ict.githubserver.service.RuleExecutorService;
import cn.ict.githubserver.service.RuleService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u89c4\u5219\u7ba1\u7406")
@RestController
@RequestMapping(path={"/rule"})
public class RuleController {
    private static final Logger log = LoggerFactory.getLogger(RuleController.class);
    @Resource
    private RuleService ruleService;
    @Resource
    private RuleExecutorService ruleExecutorService;

    @Operation(summary="\u89c4\u5219\u5217\u8868\u5c55\u793a")
    @PostMapping(value={"/list"})
    public WebResult<PageDTO<RuleResp>> list(@RequestBody RuleReq ruleReq) {
        PageDTO pageDTO = this.ruleService.pageList(ruleReq);
        return WebResult.success((Object)pageDTO);
    }

    @Operation(summary="\u6839\u636eid\u67e5\u8be2\u89c4\u5219")
    @GetMapping(value={"/{id}"})
    public WebResult<RuleResp> list(@PathVariable Long id) {
        RuleResp resp = this.ruleService.selectById(id);
        return WebResult.success((Object)resp);
    }

    @Operation(summary="\u89c4\u5219\u5217\u8868\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/download"})
    public void downLoadExcel(@RequestBody RuleReq ruleReq, HttpServletResponse response) throws IOException {
        String fileName = URLEncoder.encode("rule_export.xlsx", StandardCharsets.UTF_8.name());
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        this.ruleService.exportExcel(response.getOutputStream(), ruleReq);
    }

    @Operation(summary="\u65b0\u5efa\u89c4\u5219")
    @PostMapping(value={"/addRule"})
    public WebResult addRule(@RequestBody RuleAddReq ruleAddReq) {
        Integer num = this.ruleService.addRule(ruleAddReq);
        return WebResult.success((Object)num);
    }

    @Operation(summary="\u4fee\u6539\u89c4\u5219")
    @PutMapping(value={"/updateRule/{id}"})
    public WebResult updateRule(@PathVariable Long id, @RequestBody RuleAddReq ruleAddReq) {
        Integer num = this.ruleService.updateRule(ruleAddReq);
        return WebResult.success((Object)num);
    }

    @Operation(summary="\u5220\u9664\u89c4\u5219")
    @DeleteMapping(value={"/delRule/{id}"})
    public WebResult delRule(@PathVariable Long id) {
        Integer num = this.ruleService.delRule(id);
        return WebResult.success((Object)num);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u89c4\u5219")
    @PostMapping(value={"/delRules"})
    public WebResult delRules(@RequestBody List<Long> ids) {
        Boolean flag = this.ruleService.delRules(ids);
        return WebResult.success((Object)flag);
    }

    @Operation(summary="\u89c4\u5219\u7ec8\u6b62")
    @PostMapping(value={"/stopRule/{id}"})
    public WebResult stopRule(@PathVariable Long id) {
        Integer num = this.ruleService.stopRule(id);
        return WebResult.success((Object)num);
    }

    @Operation(summary="\u89c4\u5219\u8be6\u60c5")
    @PostMapping(value={"/ruleDetail"})
    public WebResult ruleDetail(@RequestBody RuleDetailReq ruleDetailReq) {
        PageDTO pageDTO = this.ruleService.ruleDetail(ruleDetailReq);
        return WebResult.success((Object)pageDTO);
    }

    @Operation(summary="\u6267\u884c\u60c5\u51b5\u4e0b\u7684\u89c4\u5219\u7edf\u8ba1\u5206\u6790")
    @PostMapping(value={"/ruleStatistics"})
    public WebResult ruleStatistics(@RequestBody RuleStatisticsReq ruleStatisticsReq) {
        List ruleStatistics = this.ruleService.ruleStatistics(ruleStatisticsReq);
        return WebResult.success((Object)ruleStatistics);
    }

    @Operation(summary="\u5206\u7ec4\u7edf\u8ba1\u89c4\u5219\u5185\u5bb9")
    @GetMapping(value={"/distinctCondition"})
    public WebResult groupByCondition() {
        List conditions = this.ruleService.groupByCondition();
        return WebResult.success((Object)conditions);
    }

    @Operation(summary="\u5b9e\u65f6\u6267\u884c\u60c5\u51b5")
    @PostMapping(value={"/ruleExecutorStatistics"})
    public WebResult ruleExecutorStatistics(@RequestBody RuleDetailReq ruleDetailReq) {
        PageDTO pageDTO = this.ruleExecutorService.execStatistics(ruleDetailReq);
        return WebResult.success((Object)pageDTO);
    }

    @Operation(summary="\u6839\u636e\u89c4\u5219ids\u67e5\u8be2\u89c4\u5219\u7684\u4fe1\u606f")
    @PostMapping(value={"/ids"})
    public WebResult<List<RuleResp>> selectByIds(@RequestBody List<Long> ids) {
        List resp = this.ruleService.selectByIds(ids);
        return WebResult.success((Object)resp);
    }
}

