/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.controller;

import cn.ict.githubserver.domain.WebResult;
import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.QueryResourceReq;
import cn.ict.githubserver.domain.resp.ResourceUrlResp;
import cn.ict.githubserver.service.ResourceUrlService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u91cd\u70b9\u8d44\u6e90")
@RestController
@RequestMapping(path={"/resource-url"})
public class ResourceUrlController {
    private static final Logger log = LoggerFactory.getLogger(ResourceUrlController.class);
    @Resource
    private ResourceUrlService resourceUrlService;

    @Operation(summary="\u91cd\u70b9\u8d44\u6e90\u5217\u8868\u5c55\u793a")
    @PostMapping(value={"/list"})
    public WebResult<PageDTO<ResourceUrlResp>> list(@RequestBody @Validated QueryResourceReq req) {
        PageDTO pageDTO = this.resourceUrlService.pageList(req);
        return WebResult.success((Object)pageDTO);
    }

    @Operation(summary="\u91cd\u70b9\u8d44\u6e90\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    public WebResult<ResourceUrlResp> findInfo(@PathVariable Long id) {
        ResourceUrlResp resp = this.resourceUrlService.findInfo(id);
        return WebResult.success((Object)resp);
    }

    @Operation(summary="\u91cd\u70b9\u8d44\u6e90\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/download"})
    public void downLoadExcel(@RequestBody QueryResourceReq req, HttpServletResponse response) throws IOException {
        String fileName = URLEncoder.encode("resource_url_export.xlsx", StandardCharsets.UTF_8);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        this.resourceUrlService.exportExcel(response.getOutputStream(), req);
    }
}

