/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.controller;

import cn.ict.githubserver.domain.WebResult;
import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.PublicProjectReq;
import cn.ict.githubserver.domain.resp.PublicProjectResp;
import cn.ict.githubserver.service.PublicProjectService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u516c\u5f00\u9879\u76ee")
@RestController
@RequestMapping(path={"/public-project"})
public class PublicProjectController {
    private static final Logger log = LoggerFactory.getLogger(PublicProjectController.class);
    @Autowired
    private PublicProjectService publicProjectService;

    @PostMapping(value={"/list"})
    public WebResult<PageDTO<PublicProjectResp>> list(@RequestBody PublicProjectReq publicProjectReq) {
        PageDTO pageDTO = this.publicProjectService.page(publicProjectReq);
        return WebResult.success((Object)pageDTO);
    }

    @Operation(summary="\u516c\u5f00\u5e93\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/download"})
    public void downLoadExcel(@RequestBody PublicProjectReq publicProjectReq, HttpServletResponse response) throws IOException {
        String fileName = URLEncoder.encode("public_project_export.xlsx", StandardCharsets.UTF_8.name());
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        this.publicProjectService.exportExcel(response.getOutputStream(), publicProjectReq);
    }
}

