/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.controller;

import cn.ict.githubserver.domain.WebResult;
import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.QueryMirrorSiteReq;
import cn.ict.githubserver.domain.resp.MirrorSiteResp;
import cn.ict.githubserver.service.MirrorSiteService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u955c\u50cf\u7f51\u7ad9")
@RestController
@RequestMapping(path={"/mirror-site"})
public class MirrorSiteController {
    private static final Logger log = LoggerFactory.getLogger(MirrorSiteController.class);
    @Resource
    private MirrorSiteService mirrorSiteService;

    @Operation(summary="\u955c\u50cf\u7f51\u7ad9\u5217\u8868\u5c55\u793a")
    @PostMapping(value={"/list"})
    public WebResult<PageDTO<MirrorSiteResp>> list(@RequestBody @Validated QueryMirrorSiteReq req) {
        PageDTO pageDTO = this.mirrorSiteService.pageList(req);
        return WebResult.success((Object)pageDTO);
    }

    @Operation(summary="\u955c\u50cf\u7f51\u7ad9\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    public WebResult<MirrorSiteResp> findInfo(@PathVariable Long id) {
        MirrorSiteResp resp = this.mirrorSiteService.findInfo(id);
        return WebResult.success((Object)resp);
    }

    @Operation(summary="\u955c\u50cf\u7f51\u7ad9\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/download"})
    public void downLoadExcel(@RequestBody QueryMirrorSiteReq req, HttpServletResponse response) throws IOException {
        String fileName = URLEncoder.encode("mirror_site_export.xlsx", StandardCharsets.UTF_8);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        this.mirrorSiteService.exportExcel(response.getOutputStream(), req);
    }
}

