/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.controller;

import cn.ict.githubserver.domain.WebResult;
import cn.ict.githubserver.domain.page.PageDTO;
import cn.ict.githubserver.domain.req.ImportantProjectReleaseReq;
import cn.ict.githubserver.domain.req.ImportantProjectReq;
import cn.ict.githubserver.domain.resp.ImportantProjectProfileResp;
import cn.ict.githubserver.domain.resp.ImportantProjectResp;
import cn.ict.githubserver.domain.resp.ImportantProjectTypeCountResp;
import cn.ict.githubserver.entity.ImportantProjectRelease;
import cn.ict.githubserver.service.ImportantProjectService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u91cd\u70b9\u9879\u76ee")
@RestController
@RequestMapping(path={"/important-project"})
public class ImportantProjectController {
    private static final Logger log = LoggerFactory.getLogger(ImportantProjectController.class);
    @Resource
    private ImportantProjectService importantProjectService;

    @Operation(summary="\u91cd\u70b9\u9879\u76ee\u5217\u8868\u5c55\u793a")
    @PostMapping(value={"/list"})
    public WebResult<PageDTO<ImportantProjectResp>> list(@RequestBody ImportantProjectReq importantProjectReq) {
        PageDTO pageDTO = this.importantProjectService.list(importantProjectReq);
        return WebResult.success((Object)pageDTO);
    }

    @Operation(summary="\u91cd\u70b9\u9879\u76ee\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/download"})
    public void downLoadExcel(@RequestBody ImportantProjectReq importantProjectReq, HttpServletResponse response) throws IOException {
        String fileName = URLEncoder.encode("important_project_export.xlsx", StandardCharsets.UTF_8.name());
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        this.importantProjectService.exportExcel(response.getOutputStream(), importantProjectReq);
    }

    @Operation(summary="\u91cd\u70b9\u9879\u76ee-\u9879\u76ee\u7b80\u4ecb")
    @GetMapping(value={"/profile/{id}"})
    public WebResult<ImportantProjectProfileResp> profile(@PathVariable String id) {
        ImportantProjectProfileResp importantProjectProfileResp = this.importantProjectService.profile(id);
        return WebResult.success((Object)importantProjectProfileResp);
    }

    @Operation(summary="\u91cd\u70b9\u9879\u76ee\u7684release\u4fe1\u606f")
    @PostMapping(value={"/release/detail"})
    public WebResult<PageDTO<ImportantProjectRelease>> releaseDetail(@RequestBody ImportantProjectReleaseReq req) {
        PageDTO pageDTO = this.importantProjectService.releaseDetail(req);
        return WebResult.success((Object)pageDTO);
    }

    @Operation(summary="\u9879\u76ee\u8be6\u60c5-\u5206\u6790\u7ed3\u679c-\u6570\u91cf\u7edf\u8ba1")
    @PostMapping(value={"/count/{id}"})
    public WebResult<ImportantProjectTypeCountResp> getTypeCount(@PathVariable Long id) {
        ImportantProjectTypeCountResp resp = this.importantProjectService.getTypeCount(id);
        return WebResult.success((Object)resp);
    }
}

