/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.controller;

import cn.ict.githubserver.domain.WebResult;
import cn.ict.githubserver.service.MinioService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="minio\u6587\u4ef6")
@RestController
@RequestMapping(value={"/file"})
public class FileController {
    private final MinioService minioService;

    @GetMapping(value={"/content"})
    @Operation(summary="\u8bbf\u95eeminio\u6587\u4ef6\u5185\u5bb9,\u9700\u8981\u6709\u4e00\u4e2a\u524d\u7f00\u524d\u7f00\u662ffullName + /path")
    public ResponseEntity<String> getFileContent(@RequestParam String path) {
        try {
            String content = this.minioService.getFileContent(path);
            return ResponseEntity.ok((Object)content);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/content-str"})
    @Operation(summary="\u8bbf\u95eeminio\u6587\u4ef6\u5185\u5bb9,\u9700\u8981\u6709\u4e00\u4e2a\u524d\u7f00\u524d\u7f00\u662ffullName + /path")
    public WebResult<String> getFileContentStr(@RequestParam String path) {
        try {
            String content = this.minioService.getFileContent(path);
            return WebResult.success((Object)content);
        }
        catch (Exception e) {
            return WebResult.fail((String)"\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25\uff01\uff01\uff01");
        }
    }

    public static void main(String[] args) {
    }

    public FileController(MinioService minioService) {
        this.minioService = minioService;
    }
}

