/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.config;

import cn.ict.githubserver.entity.ImportantProject;
import cn.ict.githubserver.handler.AssertListTypeHandler;
import cn.ict.githubserver.handler.BigIntArrayTypeHandler;
import cn.ict.githubserver.handler.GenericJsonTypeHandler;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.util.List;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(value={"cn.ict.githubserver.mapper"})
public class MyBatisPlusConfig {
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.MYSQL));
        return interceptor;
    }

    @Bean
    public BigIntArrayTypeHandler bigIntArrayTypeHandler() {
        return new BigIntArrayTypeHandler();
    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer() {
        return configuration -> {
            configuration.getTypeHandlerRegistry().register(ImportantProject.Dir.class, (TypeHandler)new GenericJsonTypeHandler(ImportantProject.Dir.class));
            configuration.getTypeHandlerRegistry().register(List.class, (TypeHandler)new AssertListTypeHandler());
        };
    }
}

