/*
 * Decompiled with CFR 0.152.
 */
package cn.ict.githubserver.config;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class ExecutorsConfig {
    private static final Logger log = LoggerFactory.getLogger(ExecutorsConfig.class);

    @Bean(name={"ruleTaskExecutor"})
    public TaskExecutor taskExecutor() {
        int nCPU = Runtime.getRuntime().availableProcessors();
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(2 * nCPU);
        executor.setQueueCapacity(1024);
        executor.setThreadNamePrefix("RuleExecutor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setRejectedExecutionHandler((r, executor1) -> log.error("rule task executor rejected exception: {}, {}", (Object)r, (Object)executor1));
        executor.initialize();
        return executor;
    }
}

