import React from "react";
import { Root, createRoot } from "react-dom/client";
import styles from "./styles/watermark.index.css?inline";
import { WatermarkPage } from "./components/watermark";
import { ShortcutEntry, WatermarkApi } from "./types/shared-types";
import { WithWatermarkApiContext } from "./context/watermark-api-context";

export class KiroWatermarkPage extends HTMLElement {
	private root: Root | null = null;

	private api: WatermarkApi | undefined;
	private shortcuts: ShortcutEntry[] = [];

	constructor() {
		super();
		this.attachShadow({ mode: "open" });
		this.root = this.root
			? this.root
			: createRoot(this.shadowRoot as ShadowRoot);
		const styleEl = document.createElement("style");
		styleEl.textContent = styles;
		this.shadowRoot?.appendChild(styleEl);
	}

	public setShortcuts(shortcuts: ShortcutEntry[]): void {
		this.shortcuts = shortcuts;
		this.render();
	}

	public setApi(api: WatermarkApi): void {
		this.api = api;
		this.render();
	}

	private render() {
		if (!this.api) {
			return null;
		}
		this.root?.render(
			<React.StrictMode>
				<WithWatermarkApiContext api={this.api}>
					<WatermarkPage shortcuts={this.shortcuts} />
				</WithWatermarkApiContext>
			</React.StrictMode>
		);
	}

	connectedCallback() {
		this.render();
	}
}

// Register the custom element
customElements.define("kiro-watermark-page", KiroWatermarkPage);
