import { createContext, PropsWithChildren, ReactElement } from "react";
import { WelcomeApi } from "../types/shared-types";

export const WelcomeApiContext = createContext<WelcomeApi>({} as WelcomeApi);

export function WithWelcomeApiContext<T>({
	children,
	api,
}: PropsWithChildren<{ api: WelcomeApi }>): ReactElement {
	return (
		<WelcomeApiContext.Provider value={api}>
			{children}
		</WelcomeApiContext.Provider>
	);
}
