import { createContext, PropsWithChildren, ReactElement } from "react";
import { WatermarkApi } from "../types/shared-types";

export const WatermarkApiContext = createContext<WatermarkApi>(
	{} as WatermarkApi
);

export function WithWatermarkApiContext<T>({
	children,
	api,
}: PropsWithChildren<{ api: WatermarkApi }>): ReactElement {
	return (
		<WatermarkApiContext.Provider value={api}>
			{children}
		</WatermarkApiContext.Provider>
	);
}
