import { createContext, PropsWithChildren, ReactElement } from "react";
import { SubscriptionPlansApi } from '../types/subscription-plans-types';

export const SubscriptionPlansApiContext = createContext<SubscriptionPlansApi>(
	{} as SubscriptionPlansApi
);

export function WithKiroSubscriptionPlansApiContext<T>({
	children,
	api,
}: PropsWithChildren<{ api: SubscriptionPlansApi }>): ReactElement {
	return (
		<SubscriptionPlansApiContext.Provider value={api}>
			{children}
		</SubscriptionPlansApiContext.Provider>
	);
}
