import { createContext, PropsWithChildren, ReactElement } from "react";
import { SignInPageApi } from "../types/shared-types";

export const ApiContext = createContext<SignInPageApi>({} as SignInPageApi);

export function WithApiContext({
	children,
	api,
}: PropsWithChildren<{ api: SignInPageApi }>): ReactElement {
	return <ApiContext.Provider value={api}>{children}</ApiContext.Provider>;
}
