import { createContext, PropsWithChildren, ReactElement } from "react";
import { AccountDashboardApi } from '../types/account-dashboard-types';

export const AccountDashboardApiContext = createContext<AccountDashboardApi>({} as AccountDashboardApi);

export function WithKiroAccountApiContext<T>({
	children,
	api,
}: PropsWithChildren<{ api: AccountDashboardApi }>): ReactElement {
	return (
		<AccountDashboardApiContext.Provider value={api}>
			{children}
		</AccountDashboardApiContext.Provider>
	);
}
