import { ReactElement } from "react";
import { ShortcutEntry } from "../../types/shared-types";
import { KiroMainLogoTitle } from "../kiro-main-logo-title";

interface WatermarkPageProps {
	shortcuts: ShortcutEntry[];
}

export function WatermarkPage({ shortcuts }: WatermarkPageProps): ReactElement {
	return (
		<div className="w-full h-full text-[var(--vscode-foreground)] flex flex-col items-center justify-center grayscale opacity-50">
			<div className="w-[120px] mx-auto">
				<KiroMainLogoTitle />
			</div>
			<ul className="list-none w-full flex flex-col gap-3">
				{shortcuts.map((shortcut: ShortcutEntry) => (
					<li
						key={shortcut.id}
						className={`flex items-start ${
							shortcut.highlight ? "font-bold" : "font-normal"
						}`}
					>
						<div className={`w-[50%] text-right mr-3 leading-6`}>
							{shortcut.text}
						</div>
						<div className="w-[50%] text-left">
							<ol className="list-none flex gap-1">
								{shortcut.keyLabels.map((label, index) => (
									<li
										key={index}
										className="bg-[var(--vscode-keybindingLabel-background)] px-2 py-1 rounded-sm text-xs"
									>
										{label}
									</li>
								))}
							</ol>
						</div>
					</li>
				))}
			</ul>
		</div>
	);
}
