import { ReactElement } from "react";

export function LoadingSkeleton(): ReactElement {
	return (
		<>
			{/* Loading Content */}
			<div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
				{[1, 2, 3, 4].map((index) => (
					<div
						key={index}
						className="bg-[var(--vscode-welcomePage-tileBackground)] rounded-lg p-6 border border-[var(--vscode-widget-border)] animate-pulse"
					>
						<div className="h-6 bg-[var(--vscode-widget-border)] rounded mb-4"></div>
						<div className="h-8 bg-[var(--vscode-widget-border)] rounded mb-2"></div>
						<div className="h-4 bg-[var(--vscode-widget-border)] rounded w-20 mb-6"></div>
						<div className="space-y-3 mb-6">
							{[1, 2, 3].map((featureIndex) => (
								<div
									key={featureIndex}
									className="h-4 bg-[var(--vscode-widget-border)] rounded"
								></div>
							))}
						</div>
						<div className="h-10 bg-[var(--vscode-widget-border)] rounded"></div>
					</div>
				))}
			</div>

			{/* Loading indicator */}
			<div className="flex items-center justify-center mt-8">
				<i
					className="codicon codicon-loading codicon-modifier-spin text-[var(--vscode-textLink-foreground)] mr-3"
					style={{ fontSize: "24px" }}
				></i>
				<p className="text-[var(--vscode-foreground)]">
					Loading subscription plans...
				</p>
			</div>
		</>
	);
}
