import { ReactElement } from "react";

interface ErrorBannerProps {
	error: string | null;
	hasNoPlans: boolean;
	onDismiss: () => void;
}

export function ErrorBanner({ error, hasNoPlans, onDismiss }: ErrorBannerProps): ReactElement | null {
	if (!error && !hasNoPlans) {
		return null;
	}

	return (
		<div className="mb-6 p-4 bg-[var(--vscode-inputValidation-errorBackground)] border border-[var(--vscode-inputValidation-errorBorder)] rounded-lg flex items-center justify-between">
			<span className="text-[var(--vscode-inputValidation-errorForeground)] text-sm">
				{error || "No Subscription plan available"}
			</span>
			<button
				onClick={onDismiss}
				className="text-[var(--vscode-inputValidation-errorForeground)] hover:text-[var(--vscode-foreground)] ml-4 p-1 rounded hover:bg-[var(--vscode-toolbar-hoverBackground)] transition-colors"
				aria-label="Dismiss error"
			>
				<i
					className="codicon codicon-close"
					style={{ fontSize: "16px" }}
				></i>
			</button>
		</div>
	);
}
