import { ChangeEvent, ReactElement } from "react";

interface SignInInputProps {
	id: string;
	name: string;
	label: string;
	value: string;
	helperText: string;
	onChange: (event: ChangeEvent<HTMLInputElement>) => void;
	disabled?: boolean;
	placeholder?: string;
	autoFocus?: boolean;
}

/**
 * Text input for Sign in experience
 */
export function SignInInput({
	id,
	name,
	value,
	label,
	helperText,
	onChange,
	disabled,
	placeholder,
	autoFocus,
}: SignInInputProps): ReactElement {
	return (
		<div>
			<label htmlFor={id} className="text-[14px]/5 font-medium">
				{label}
			</label>
			<p
				id={`${id}_helperText`}
				className="text-[12px]/5 font-normal secondary-text"
			>
				{helperText}
			</p>
			<input
				id={id}
				aria-describedby={`${id}_helperText`}
				type="text"
				value={value}
				name={name}
				disabled={disabled}
				autoFocus={autoFocus}
				placeholder={placeholder}
				className="rounded-lg sign-in-input p-3 w-full text-[14px]/6 font-normal mt-2 disabled:text-kiro-sign-in-social-input-disabled-text disabled:bg-kiro-sign-in-social-input-disabled-background"
				onChange={onChange}
			></input>
		</div>
	);
}
