import { ReactElement, useContext, useState } from "react";
import { KiroButton } from "../kiro-button";
import { OnboardingStepContainer } from "./onboarding-step-container";
import { ThemePicker } from "./theme-picker";
import { useOnboardingState } from "../../hooks";
import { ColorTheme } from "../../types/shared-types";

interface OnboardingStepThemeProps {
	onNext: () => void;
	themes: ColorTheme[];
	currentThemeId: string;
}

export function OnboardingStepTheme({
	onNext,
	themes,
	currentThemeId,
}: OnboardingStepThemeProps): ReactElement {
	const { onboardingState: onboardingSettingsState } =
		useOnboardingState("import-settings");

	const { runOnboardingStep } = useOnboardingState("update-theme");

	async function onSelectTheme(themeId: string): Promise<void> {
		await runOnboardingStep({ input: { theme: themeId } });
	}

	return (
		<OnboardingStepContainer
			title="Choose your theme"
			body={
				<ThemePicker
					themes={themes}
					importedTheme={onboardingSettingsState["importedThemeName"]}
					currentThemeId={currentThemeId}
					onChange={onSelectTheme}
				/>
			}
			controls={<KiroButton onClick={onNext}>Continue</KiroButton>}
		/>
	);
}
