import { ReactElement } from "react";
import { OnboardingStepState } from "../../types/shared-types";

interface OnboardingStepStatusProps {
	status: OnboardingStepState["status"];
	completeTitle: string;
	logMessages: string[];
}

export function OnboardingStepStatus({
	logMessages,
	status,
	completeTitle,
}: OnboardingStepStatusProps): ReactElement | null {
	if (status === "incomplete") {
		return null;
	}
	const message = logMessages[logMessages.length - 1] || "Working on it ...";
	if (status === "error") {
		return <p>{message || "An error occurred during this step"}</p>;
	}

	return (
		<div className={`w-100 overflow-hidden group ${status}`}>
			<div
				className={`w-200 flex flex-row items-center transition-transform duration-300 ease-in-out transform translate-y-0 group-[.loading]:translate-x-0 group-[.complete]:-translate-x-100`}
			>
				<div
					className={`w-100 flex flex-col gap-2 items-center p-5 rounded-2xl glass-card`}
				>
					<p className="w-full truncate">{message}</p>
				</div>

				<div className={`w-100`}>
					<h3 className="text-[14px]/5 font-medium flex gap-1 items-center justify-center">
						<i className="codicon codicon-pass-filled"></i>
						<span>{completeTitle}</span>
					</h3>
				</div>
			</div>
		</div>
	);
}
