import { ReactElement } from "react";

interface OnboardingStepContainerProps {
	title: string;
	body: React.ReactNode;
	controls: React.ReactNode;
}

export function OnboardingStepContainer({
	title,
	controls,
	body,
}: OnboardingStepContainerProps): ReactElement {
	return (
		<div className="flex flex-col items-center gap-7">
			<h1 className="text-[26px]/4.5 font-normal text-[var(--vscode-textLink-foreground)]">
				{title}
			</h1>
			<div className="text-[14px]/5 font-normal w-100 text-center">{body}</div>
			<div className="w-[216px] flex flex-col gap-3">{controls}</div>
		</div>
	);
}
