import { ReactElement } from "react";
import { KiroButton } from "../kiro-button";
import { OnboardingStepContainer } from "./onboarding-step-container";
import { useOnboardingState } from "../../hooks";
import { OnboardingStepStatus } from "./onboarding-step-status";

interface OnboardingStepCliProps {
	onNext: () => void;
	onComplete: () => void;
}

export function OnboardingStepCli({
	onNext,
	onComplete,
}: OnboardingStepCliProps): ReactElement {
	const { runOnboardingStep, onboardingState } =
		useOnboardingState("install-cli");

	async function setUpShell(): Promise<void> {
		const newState = await runOnboardingStep({
			input: { install: true },
			minDuration: 500,
		});
		if (newState.status === "complete") {
			onComplete();
		}
	}

	return (
		<OnboardingStepContainer
			title="Set up shell"
			body={
				<div className="flex flex-col gap-5">
					<p>
						This integrates Kiro with your shell and allows you to open any
						project from your Terminal.
					</p>
					<OnboardingStepStatus
						logMessages={onboardingState.messages || []}
						status={onboardingState.status}
						completeTitle="Set up complete"
					/>
				</div>
			}
			controls={
				onboardingState.status !== "complete" ? (
					<>
						<KiroButton
							loading={onboardingState.status === "loading"}
							onClick={setUpShell}
						>
							Set up shell
						</KiroButton>
						<KiroButton style="secondary" onClick={onNext}>
							Skip
						</KiroButton>
					</>
				) : (
					<KiroButton onClick={onNext} style="secondary">
						Done
					</KiroButton>
				)
			}
		/>
	);
}
